#include "UG_LIB.h"

static void ug_write_param_info_
 (INT_ Write_Blank_Def_Flag,
  INT_ Write_Flag,
  char *Param_Name,
  char *Param_Alt_Name,
  char *Param_Info,
  char *Param_Doc,
  char *Def_Text);

static void ug_write_param_info_heading_ (INT_ Rank, INT_ Type, INT_ Write_Flag);

INT_ ug_write_param_info
 (INT_ Write_Flag,
  UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Write information on all UG parameters to standard output.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_write_param_info.c,v 1.60 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Def_Text;

  INT_1D *Index_List = NULL;

  INT_ Error_Flag, Index, Index_, Max_Params, Max_Rank, Rank, Rank_Flag;

  if (Write_Flag == 0)
    return (0);

  Error_Flag = 0;

  Max_Params = UG_Param_Struct_Ptr->Number_of_Char_Params;
  Max_Params = MAX (Max_Params, UG_Param_Struct_Ptr->Number_of_Int_Params);
  Max_Params = MAX (Max_Params, UG_Param_Struct_Ptr->Number_of_Double_Params);

  Index_List = (INT_1D *) ug_malloc (&Error_Flag, Max_Params * sizeof (INT_1D));

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 100422 : unable to allocate required memory ***");
    ug_free (Index_List);
    return (100422);
  }

  if (Write_Flag == 2 || Write_Flag == 4)
  {
    ug_parse_text_string (0, "\
; \
_______________________________________________________________________________ ; \
; \
Input Parameters ; \
_______________________________________________________________________________ ; \
; \
Input parameters, other than input \"flag parameters\", may be specified \
in any one of the following forms. ; \
; ^ \
param_name=param_value ; \
param_name param_value ; \
-param_name param_value ; \
; ^ \
Also, note that some input parameter names have synonyms and either one may \
be used. ; \
; \
There are four basic types of parameters. ; \
; ^ \
Flag Parameters : Parameters that set multiple options and/or numeric \
parameters. They all are of the form -param_name and require use of a - \
prefix. \
A specified value may or may not be required. ; \
; \
Option or ID Parameters :  Parameters that set or control specific options, \
operation counts, or specify ID values. \
If a list of parameters are required, then the list must include \
parameters that are separated by commas. If there is only one parameter \
in a list then it must be terminated with a comma. \
A specified integer value or list of values is always required. ; \
; \
Numeric Parameters : Parameters that set values for or adjust \
specific algorithms. \
If a list of parameters are required, then the list must include \
parameters that are separated by commas. If there is only one parameter \
in a list then it must be terminated with a comma. \
A specified floating-point value or list of values is always required. ; \
; \
String Parameters : Parameters that set specific names for files and \
directories. String Parameters are typically Program Parameters. \
A specified character string value is always required. ; \
; ^ \
Parameters are sorted by type and typical frequency of usage in the \
following descriptions. Note that the majority of the following parameters are \
NOT typically used. This is particularly true of \"Numeric Parameters\". ; \
; \
The following list also includes \"Program Parameters\" that are specific to \
execution of the main program. \
Program Parameters may be any of the previously described parameter types. \
They typically control I/O functions, are not ordered by rank, \
and are listed first in the following.");
  }

  ug_write_param_info_heading_ (0, 0, Write_Flag);

  Max_Rank = (Write_Flag == -1 || Write_Flag == 1 || Write_Flag == 2) ? 4: 5;

  for (Rank = -1; Rank <= Max_Rank; ++Rank)
  {
    if (Rank == 0)
      ++Rank;

    Rank_Flag = 0;

    Index = 0;

    while (Index < UG_Param_Struct_Ptr->Number_of_Char_Params && Rank_Flag == 0)
    {
      if (UG_Param_Struct_Ptr->Char_Param_Rank[Index] == Rank &&
          //UG_Param_Struct_Ptr->Char_Param_Type[Index] > 1)
          UG_Param_Struct_Ptr->Char_Param_Type[Index] >= 1)
          Rank_Flag = 1;

      ++Index;
    }

    if (Rank_Flag)
    {
      Error_Flag = ug_sort_string_list (0, UG_Param_Struct_Ptr->Number_of_Char_Params, 25, 
                                       (char *) UG_Param_Struct_Ptr->Char_Param_Name, Index_List);

      if (Error_Flag)
      {
        ug_free (Index_List);
        return (Error_Flag);
      }

      ug_write_param_info_heading_ (Rank, 1, Write_Flag);

      for (Index_ = 0; Index_ < UG_Param_Struct_Ptr->Number_of_Char_Params; ++Index_)
      {
        Index = Index_List[Index_];

        if (UG_Param_Struct_Ptr->Char_Param_Rank[Index] == Rank && 
            UG_Param_Struct_Ptr->Char_Param_Type[Index] > 1)
        {
          if (strcmp (UG_Param_Struct_Ptr->Def_Char_Param[Index], ""))
          {
            if (Write_Flag == -1 || Write_Flag == 1 || Write_Flag == 3)
              strncpy (Def_Text, UG_Param_Struct_Ptr->Def_Char_Param[Index], UG_MAX_CHAR_STRING_LENGTH-27-1);
            else
            {
              strcpy (Def_Text, "Equivalent to ");
              strncat (Def_Text, UG_Param_Struct_Ptr->Def_Char_Param[Index], UG_MAX_CHAR_STRING_LENGTH-14-3-74-1);
            }
          }
          else
            strcpy (Def_Text, "");

          if (Write_Flag == 2 || Write_Flag == 4)
          {
            if (strcmp (Def_Text, ""))
              strcat (Def_Text, " ; ");

            if (UG_Param_Struct_Ptr->Char_Param_Type[Index] == 2)
              strcat (Def_Text, "No parameter value should be specified.");
            else
              strcat (Def_Text, "Parameter value must be specified for the last equivalent parameter value.");
          }

          ug_write_param_info_ (0, Write_Flag,
                                (char *) &(UG_Param_Struct_Ptr->Char_Param_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Char_Param_Alt_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Char_Param_Info[Index]),
                                UG_Param_Struct_Ptr->Char_Param_Doc[Index],
                                (char *) Def_Text);
        }
      }
    }

    Rank_Flag = 0;

    Index = 0;

    while (Index < UG_Param_Struct_Ptr->Number_of_Int_Params && Rank_Flag == 0)
    {
      if (UG_Param_Struct_Ptr->Int_Param_Rank[Index] == Rank)
        Rank_Flag = 1;

      ++Index;
    }

    if (Rank_Flag)
    {
      Error_Flag = ug_sort_string_list (0, UG_Param_Struct_Ptr->Number_of_Int_Params, 25, 
                                       (char *) UG_Param_Struct_Ptr->Int_Param_Name, Index_List);

      if (Error_Flag)
      {
        ug_free (Index_List);
        return (Error_Flag);
      }

      if (Rank > 0)
        ug_write_param_info_heading_ (Rank, 2, Write_Flag);

      for (Index_ = 0; Index_ < UG_Param_Struct_Ptr->Number_of_Int_Params; ++Index_)
      {
        Index = Index_List[Index_];

        if (UG_Param_Struct_Ptr->Int_Param_Rank[Index] == Rank)
        {
          if (UG_Param_Struct_Ptr->Int_Param_Vector_Entries[Index] == -1)
          {
            if (UG_Param_Struct_Ptr->Max_Int_Param[Index] > UG_Param_Struct_Ptr->Min_Int_Param[Index])
              snprintf (Def_Text, sizeof(Def_Text), "default=%-10i   min=%-10i   max=%-10i",
                       (int) UG_Param_Struct_Ptr->Def_Int_Param[Index],
                       (int) UG_Param_Struct_Ptr->Min_Int_Param[Index],
                       (int) UG_Param_Struct_Ptr->Max_Int_Param[Index]);
            else
              snprintf (Def_Text, sizeof(Def_Text), "default=%-10i", (int) UG_Param_Struct_Ptr->Def_Int_Param[Index]);
          }
          else
            strcpy (Def_Text, "");

          ug_write_param_info_ (1, Write_Flag,
                                (char *) &(UG_Param_Struct_Ptr->Int_Param_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Int_Param_Alt_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Int_Param_Info[Index]),
                                UG_Param_Struct_Ptr->Int_Param_Doc[Index],
                                (char *) Def_Text);
        }
      }
    }

    Rank_Flag = 0;

    Index = 0;

    while (Index < UG_Param_Struct_Ptr->Number_of_Double_Params && Rank_Flag == 0)
    {
      if (UG_Param_Struct_Ptr->Double_Param_Rank[Index] == Rank)
        Rank_Flag = 1;

      ++Index;
    }

    if (Rank_Flag)
    {
      Error_Flag = ug_sort_string_list (0, UG_Param_Struct_Ptr->Number_of_Double_Params, 25, 
                                       (char *) UG_Param_Struct_Ptr->Double_Param_Name, Index_List);

      if (Error_Flag)
      {
        ug_free (Index_List);
        return (Error_Flag);
      }

      if (Rank > 0)
        ug_write_param_info_heading_ (Rank, 3, Write_Flag);

      for (Index_ = 0; Index_ < UG_Param_Struct_Ptr->Number_of_Double_Params; ++Index_)
      {
        Index = Index_List[Index_];

        if (UG_Param_Struct_Ptr->Double_Param_Rank[Index] == Rank)
        {
          if (UG_Param_Struct_Ptr->Double_Param_Vector_Entries[Index] == -1)
          {
            if (UG_Param_Struct_Ptr->Max_Double_Param[Index] > UG_Param_Struct_Ptr->Min_Double_Param[Index])
              snprintf (Def_Text, sizeof(Def_Text), "default=%-10g   min=%-10g   max=%-10g",
                       UG_Param_Struct_Ptr->Def_Double_Param[Index],
                       UG_Param_Struct_Ptr->Min_Double_Param[Index],
                       UG_Param_Struct_Ptr->Max_Double_Param[Index]);
            else
              snprintf (Def_Text, sizeof(Def_Text), "default=%-10g", UG_Param_Struct_Ptr->Def_Double_Param[Index]);
          }
          else
            strcpy (Def_Text, "");

          ug_write_param_info_ (1, Write_Flag,
                                (char *) &(UG_Param_Struct_Ptr->Double_Param_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Double_Param_Alt_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Double_Param_Info[Index]),
                                UG_Param_Struct_Ptr->Double_Param_Doc[Index],
                                (char *) Def_Text);
        }
      }
    }

    Rank_Flag = 0;

    Index = 0;

    while (Index < UG_Param_Struct_Ptr->Number_of_Char_Params && Rank_Flag == 0)
    {
      if (UG_Param_Struct_Ptr->Char_Param_Rank[Index] == Rank &&
          UG_Param_Struct_Ptr->Char_Param_Type[Index] == 1)
        Rank_Flag = 1;

      ++Index;
    }

    if (Rank_Flag)
    {
      Error_Flag = ug_sort_string_list (0, UG_Param_Struct_Ptr->Number_of_Char_Params, 25, 
                                       (char *) UG_Param_Struct_Ptr->Char_Param_Name, Index_List);

      if (Error_Flag)
      {
        ug_free (Index_List);
        return (Error_Flag);
      }

      if (Rank > 0)
        ug_write_param_info_heading_ (Rank, 4, Write_Flag);

      for (Index_ = 0; Index_ < UG_Param_Struct_Ptr->Number_of_Char_Params; ++Index_)
      {
        Index = Index_List[Index_];

        if (UG_Param_Struct_Ptr->Char_Param_Rank[Index] == Rank &&
            UG_Param_Struct_Ptr->Char_Param_Type[Index] == 1)
        {
          strcpy (Def_Text, "default=");
          strncat (Def_Text, UG_Param_Struct_Ptr->Def_Char_Param[Index], UG_MAX_CHAR_STRING_LENGTH-9);

          ug_write_param_info_ (1, Write_Flag,
                                (char *) &(UG_Param_Struct_Ptr->Char_Param_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Char_Param_Alt_Name[Index]),
                                (char *) &(UG_Param_Struct_Ptr->Char_Param_Info[Index]),
                                UG_Param_Struct_Ptr->Char_Param_Doc[Index],
                                (char *) Def_Text);
        }
      }
    }
  }

  ug_free (Index_List);

  return (0);

}

static void ug_write_param_info_
 (INT_ Write_Blank_Def_Flag,
  INT_ Write_Flag,
  char *Param_Name,
  char *Param_Alt_Name,
  char *Param_Info,
  char *Param_Doc,
  char *Def_Text)

{

/*
 * Write information on a given UG parameter to standard output.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_write_param_info.c,v 1.60 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text_String;

  INT_ i, n;

  if (Write_Flag == -1)
  {
    snprintf (Text_String, sizeof (Text_String), "%-24s : %s", Param_Name, Param_Info);
    ug_message (Text_String);

    if (strcmp (Param_Alt_Name, ""))
    {
      snprintf (Text_String, sizeof (Text_String), "%-24s : %s", Param_Alt_Name, Param_Info);
      ug_message (Text_String);
    }
  }

  else if (Write_Flag == 1 || Write_Flag == 3)
  {
    snprintf (Text_String, sizeof (Text_String), "%-24s : %s", Param_Name, Param_Info);
    ug_message (Text_String);

    if (strcmp (Param_Alt_Name, ""))
    {
      snprintf (Text_String, sizeof (Text_String), "%-24s : synonymous names", Param_Alt_Name);
      ug_message (Text_String);
    }

    if (strcmp (Def_Text, ""))
      ug_parse_text_string (27, Def_Text);
    else if (Write_Blank_Def_Flag)
    {
      strcpy (Text_String, "default=");
      ug_parse_text_string (27, Text_String);
    }
  }

  else if (Write_Flag == 2 || Write_Flag == 4)
  {
    snprintf (Text_String, sizeof (Text_String), "%-s %-s", Param_Name, Param_Alt_Name);
    ug_message (Text_String);

    n = (INT_) strlen (Text_String);

    strcpy (Text_String, "");

    for (i = 1; i <= n; ++i)
    {
      strcat (Text_String, "-");
    }

    ug_message (Text_String);

    ug_parse_text_string (0, Param_Info);
    ug_parse_text_string (0, Param_Doc);

    if (strcmp (Def_Text, ""))
      ug_parse_text_string (0, Def_Text);

    ug_message (" ");
  }

  return;
}

static void ug_write_param_info_heading_ (INT_ Rank, INT_ Type, INT_ Write_Flag)
{
  CHAR_81 Label;

  if (Rank == 0 && Type == 0)
  {
    if (Write_Flag == -1 || Write_Flag == 1 || Write_Flag == 3)
    {
      ug_message ("PARAMETER NAME             DESCRIPTION");
      ug_message ("________________________   _____________________________________________________");
    }

    return;
  }

  if (Write_Flag == -1 || Write_Flag == 1 || Write_Flag == 3)
    strcpy (Label, "                           ");
  else
    strcpy (Label, "");

  if (Rank == -1)
    strcat (Label, "PROGRAM CONTROL & I/O PARAMETERS");
  else if (Type == 1)
    strcat (Label, "FLAG PARAMETERS");
  else if (Type == 2)
    strcat (Label, "OPTION PARAMETERS");
  else if (Type == 3)
    strcat (Label, "NUMERIC PARAMETERS");
  else if (Type == 4)
    strcat (Label, "STRING PARAMETERS");

  if (Rank == 1)
    strcat (Label, " (OFTEN USED)");
  else if (Rank == 2)
    strcat (Label, " (SOMETIMES USED)");
  else if (Rank == 3)
    strcat (Label, " (SELDOM USED)");
  else if (Rank == 4)
    strcat (Label, " (RARELY USED)");
  else if (Rank == 5)
    strcat (Label, " (DO NOT CHANGE)");

  ug_message ("");
  ug_message (Label);

  if (Write_Flag == 2 || Write_Flag == 4)
    ug_message ("________________________________________________________________________________");

  ug_message (" ");

  return;
}
