#include "UG_LIB.h"

INT_ ug_write_arg_file
 (int argc,
  char *argv[],
  char Arg_File_Name[])

{

/*
 * Write an input argument file.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_write_arg_file.c,v 1.6 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Arg_File = NULL;

  INT_ i, Error_Flag, Write_Flag;

  if (strcmp (Arg_File_Name, "") == 0)
    return (0);

  Arg_File = ug_fopen (Arg_File_Name, "w");

  if (Arg_File == NULL)
  {
    ug_error_message ("*** ERROR 422 : error opening input argument file for writing ***");
    return (422);
  }

  Error_Flag = 0;

  Write_Flag = fprintf (Arg_File, "#%s\n", argv[0]);

  if (Write_Flag <= 0) Error_Flag = 1;

  for (i = 1; i < argc; ++i)
  {
    Write_Flag = fprintf (Arg_File, "%s\n", argv[i]);

    if (Write_Flag <= 0) Error_Flag = 1;
  }

  ug_fclose (Arg_File);

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 423 : error writing input argument file ***");
    return (423);
  }

  return (0);

}
