#include "UG_LIB.h"

void ug_version_info (char Lib_Name[],
                      void (*Version_Function) (char[],
                                                char[],
                                                char[],
                                                char[]))

/*
 * Write library version information.
 *
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_version_info.c,v 1.20 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

{

  static INT_ Build_Number_1 = 0;
  static INT_ Build_Number_2 = 0;
  static INT_ Build_Number_3 = 0;

  CHAR_81 Compile_Date, Compile_OS, Text, Version_Date, Version_Number;

  INT_ v1, v2, v3;

  if (strcmp (Lib_Name, "Build_Number") == 0)
  {
    ug_message ("");

    snprintf (Text, sizeof(Text), "Executable   : Build Number   %i.%i.%i", (int) Build_Number_1, (int) Build_Number_2, (int) Build_Number_3);
    ug_message (Text);

    Build_Number_1 = 0;
    Build_Number_2 = 0;
    Build_Number_3 = 0;
  }
  else if (strcmp (Lib_Name, "*Build_Number") == 0)
  {
    snprintf (Text, sizeof(Text), "%i.%i.%i", (int) Build_Number_1, (int) Build_Number_2, (int) Build_Number_3);
    ug_message (Text);

    Build_Number_1 = 0;
    Build_Number_2 = 0;
    Build_Number_3 = 0;
  }
  else
  {
    (*Version_Function) (Compile_Date, Compile_OS, Version_Date, Version_Number);

    ug_message ("");

    snprintf (Text, sizeof(Text), "Lib Info     : Library Name   %s", Lib_Name);
    ug_message (Text);

    snprintf (Text, sizeof(Text), "Lib Info     : Version Number %-50s", Version_Number);
    ug_message (Text);

    snprintf (Text, sizeof(Text), "Lib Info     : Version Date   %-50s", Version_Date);
    ug_message (Text);

    snprintf (Text, sizeof(Text), "Lib Info     : Compile OS     %-50s", Compile_OS);
    ug_message (Text);

    snprintf (Text, sizeof(Text), "Lib Info     : Compile Date   %-50s", Compile_Date);
    ug_message (Text);

    sscanf (Version_Number, "%i.%i.%i", (int *) &v1, (int *) &v2, (int *) &v3);

    Build_Number_1 = Build_Number_1 + v1; 
    Build_Number_2 = Build_Number_2 + v2; 
    Build_Number_3 = Build_Number_3 + v3; 
  }

  return;

}
