#include "UG_LIB.h"

INT_ ug_startup
 (int argc,
  char **argv)

{

/*
 * Start memory and file status monitors and create tmp directory using
 * parameter options obtained from the argument vector.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_startup.c,v 1.20 2022/03/14 05:00:04 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Name, TMP_File_Dir;

  INT_ i, Error_Flag;
  INT_ File_Status_Monitor_Flag = 0;
  INT_ Memory_Monitor_Flag = 0;

  strcpy (TMP_File_Dir, "_null_");

  if (argc == 1)
    return (0);

  for (i = 1; i < argc; ++i)
  {
    // set File_Status_Monitor_Flag

    if (strcmp (argv[i], "-File_Status_Monitor") == 0)
      File_Status_Monitor_Flag = 1;

    // set Memory_Monitor_Flag

    if (strcmp (argv[i], "-Memory_Monitor") == 0)
      Memory_Monitor_Flag = 1;

    if (strcmp (argv[i], "-Memory_Monitor2") == 0)
      Memory_Monitor_Flag = 2;

    // set TMP_File_Dir

    if (i < argc-1 && strcmp (argv[i], "-TMP_File_Dir") == 0)
      strcpy (TMP_File_Dir, argv[i+1]);
  }

  // start file status monitor

  if (File_Status_Monitor_Flag == 1)
    ug_file_status_monitor ("on");

  // start memory monitor

  if (Memory_Monitor_Flag == 1)
    ug_memory_monitor ("on");
  else if (Memory_Monitor_Flag == 2)
    ug_memory_monitor ("full_on");

  // create directory for temporary files

  if (strcmp (TMP_File_Dir, "_null_"))
  {
    ug_get_tmp_file_name ("_null_", Name);

    if (strcmp (Name, "_null_") == 0)
    {
      Error_Flag = ug_set_tmp_file_dir (TMP_File_Dir);

      if (Error_Flag)
        return (Error_Flag);
    }
  }

  return (0);

}
