#include "UG_LIB.h"

/*
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_split_arg.c,v 1.1 2022/04/05 22:03:02 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

INT_ ug_split_arg (
  char *argv[],
  int argc,
  char split_flag[],
  char ***argv_1,
  int *argc_1,
  char ***argv_2,
  int *argc_2)
{
  // Split argument vector into two argument vectors assuming the first set of
  // arguments is followed by the one equal to the split flag the second set of
  // arguments after that flag.

  INT_ ierr = 0;
  int i = 0;
  int j = 0;
  int k = 0;

  *argv_1 = NULL;
  *argc_1 = 0;
  *argv_2 = NULL;
  *argc_2 = 0;

  // return if argument vector is NULL

  if (argc == 0 || argv == NULL) return 0;

  // count number of AFLR4 arguments

  while (i < argc && strcmp (argv[i], split_flag))
    i++;

  *argc_1 = i;

  // set number of AFLR3 arguments

  *argc_2 = MAX (1, argc-(*argc_1));

  // allocate AFLR3 and AFLR4 argument vectors

  *argv_2 = (char **) ug_malloc (&ierr, (*argc_2+1) * sizeof (char *));
  *argv_1 = (char **) ug_malloc (&ierr, (*argc_1+1) * sizeof (char *));

  if (ierr) {
    ug_error_message ("*** ERROR 103600 : unable to allocate required memory ***");
    return 103600;
  }

  // allocate and set each AFLR4 argument

  for (i = 0; i < *argc_1; i++) {

    (*argv_1)[i] = (char *) ug_malloc (&ierr, (strlen(argv[i])+1) * sizeof(char));

    if (ierr) {
      ug_error_message ("*** ERROR 103601 : unable to allocate required memory ***");
      return 103601;
    }

    strcpy ((*argv_1)[i], argv[i]);
  }

  (*argv_1)[*argc_1] = NULL;

  // allocate and set each AFLR3 argument

  for (i = *argc_1; i < (*argc_1)+(*argc_2); i++) {

    k = (i == *argc_1) ? 0: i;
 
    (*argv_2)[j] = (char *) ug_malloc (&ierr, (strlen(argv[k])+1) * sizeof(char));

    if (ierr) {
      ug_error_message ("*** ERROR 103602 : unable to allocate required memory ***");
      return 103602;
    }

    strcpy ((*argv_2)[j], argv[k]);

    j++;
  }

  (*argv_2)[*argc_2] = NULL;

  return 0;
}
