#include "UG_LIB.h"

int ug_sort_string_list_test
 (const void *a_ptr,
  const void *b_ptr);

INT_ ug_sort_string_list
 (INT_ m,
  INT_ n,
  INT_ nc,
  char * string_values,
  INT_1D * list)

{

/*
 * Sort a list of integer values and create a corresponding index.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_sort_string_list.c,v 1.9 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  char *map = NULL;

  CHAR_UG_MAX text;

  INT_ i;

  INT_ ierr = 0;

  map = (char *) ug_malloc (&ierr, 2 * n * nc * sizeof (char));

  if (ierr > 0)
  {
    ug_free (map);
    ug_error_message ("*** ERROR 100421 : unable to allocate space for sorting data ***");
    return (100421);
  }

  if (sizeof (INT_) != sizeof (LONG_LONG_int))
  {
    for (i = 0; i < n; ++i)
    {
      strcpy (&(map[i*2*nc]), "");
      strncat (&(map[i*2*nc]), &(string_values[i*nc]), nc);

      snprintf (text, sizeof(text), "%i", (int) i);
      strcpy (&(map[(i*2+1)*nc]), "");
      strncat (&(map[(i*2+1)*nc]), text, nc);
    }
  }
  else
  {
    for (i = 0; i < n; ++i)
    {
      strcpy (&(map[i*2*nc]), "");
      strncat (&(map[i*2*nc]), &(string_values[i*nc]), nc);

      snprintf (text, sizeof(text), "%lli", (LONG_LONG_int) i);
      strcpy (&(map[(i*2+1)*nc]), "");
      strncat (&(map[(i*2+1)*nc]), text, nc);
    }
  }

  qsort (map, (size_t) n, (size_t) (2*nc*sizeof (char)), ug_sort_string_list_test);

  if (sizeof (INT_) != sizeof (LONG_LONG_int))
  {
    for (i = 0; i < n; ++i)
    {
      sscanf (&(map[(i*2+1)*nc]), "%i", (int *) &(list[i]));
    }
  }
  else
  {
    for (i = 0; i < n; ++i)
    {
      sscanf (&(map[(i*2+1)*nc]), "%lli", (LONG_LONG_int *) &(list[i]));
    }
  }

  if (m)
  {
    for (i = 0; i < n; ++i)
    {
      strcpy (&(string_values[i*nc]), "");
      strncat (&(string_values[i*nc]), &(map[i*2*nc]), nc);
    }
  }

  ug_free (map);

  return (0);
}

int ug_sort_string_list_test
 (const void *a_ptr,
  const void *b_ptr)

{
  char *a;
  char *b;

  int compare;

  a = (char *) a_ptr;
  b = (char *) b_ptr;

  compare = strcoll (a, b);

  if (compare < 0)
    return (-1);

  else if (compare > 0)
    return (1);

  else
    return (0);
}
