#include "UG_LIB.h"

static INT_ code_ = 0;
static INT_ n_type_1 = 0;
static INT_ n_type_2 = 0;
static INT_ (*initialize_prog_param_function_type_1_[50]) (INT_ code, UG_Param_Struct *Param_Struct_Ptr);
static INT_ (*initialize_prog_param_function_type_2_[50]) (UG_Param_Struct *Param_Struct_Ptr);

INT_ ug_set_prog_param (char **prog_argv,
                        int prog_argc,
                        INT_ Check_Flag,
                        INT_ Ignore_Error_Flag,
                        INT_ Message_Flag,
                        UG_Param_Struct **Param_Struct_Ptr)
{

/*
 * Malloc and initialize program related parameter structure arrays.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_set_prog_param.c,v 1.10 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ i_type_1, i_type_2, Error_Flag;

  *Param_Struct_Ptr = NULL;

  Error_Flag = ug_malloc_param (Param_Struct_Ptr);

  if (Error_Flag == 0)
    Error_Flag = ug_initialize_param (code_, *Param_Struct_Ptr);

  for (i_type_1 = 0; i_type_1 < n_type_1; ++i_type_1)
  {
    if (Error_Flag == 0)
      Error_Flag = (*initialize_prog_param_function_type_1_[i_type_1]) (code_, *Param_Struct_Ptr);
  }

  for (i_type_2 = 0; i_type_2 < n_type_2; ++i_type_2)
  {
    if (Error_Flag == 0)
      Error_Flag = (*initialize_prog_param_function_type_2_[i_type_2]) (*Param_Struct_Ptr);
  }

  // set input parameters in parameter structure from argument list

  if (Error_Flag == 0)
    Error_Flag = ug_set_params_from_arg (prog_argv, prog_argc,
                                         Ignore_Error_Flag, Message_Flag,
                                         *Param_Struct_Ptr);
  if (Error_Flag == 0 && Check_Flag)
    ug_check_param (*Param_Struct_Ptr);

  if (Error_Flag)
  {
    ug_free_param (*Param_Struct_Ptr);
    *Param_Struct_Ptr = NULL;
  }

  return (Error_Flag);
}

INT_ ug_check_prog_param_functions (void)
{
  if (n_type_1 || n_type_2)
    return (1);

  return (0);
}

void ug_set_prog_param_code (INT_ code)
{
  code_ = code;

  return;
}

void ug_set_prog_param_function1 (INT_ (*initialize_prog_param_function) (INT_ code, UG_Param_Struct *Param_Struct_Ptr))
{
  INT_ i_type_1;
  INT_ set = 1;

  if (n_type_1 < 50)
  {
    i_type_1 = 0;

    do
    {
      if (initialize_prog_param_function_type_1_[i_type_1] == initialize_prog_param_function)
        set = 0;

      ++i_type_1;
    }
    while (i_type_1 < n_type_1 && set);

    if (set)
    {
      i_type_1 = n_type_1;

      initialize_prog_param_function_type_1_[i_type_1] = initialize_prog_param_function;

      ++n_type_1;
    }
  }

  return;
}

void ug_set_prog_param_function2 (INT_ (*initialize_prog_param_function) (UG_Param_Struct *Param_Struct_Ptr))
{
  INT_ i_type_2;
  INT_ set = 2;

  if (n_type_2 < 50)
  {
    i_type_2 = 0;

    do
    {
      if (initialize_prog_param_function_type_2_[i_type_2] == initialize_prog_param_function)
        set = 0;

      ++i_type_2;
    }
    while (i_type_2 < n_type_2 && set);

    if (set)
    {
      i_type_2 = n_type_2;

      initialize_prog_param_function_type_2_[i_type_2] = initialize_prog_param_function;

      ++n_type_2;
    }
  }

  return;
}
