#include "UG_LIB.h"

INT_ ug_set_param_from_string
 (char ***argv,
  char **Opt_Param_Strings_Ptr,
  char **Param_Name_Ptr,
  char *Param_String_Ptr,
  char *Next_Param_String_Ptr,
  int *argc,
  INT_ Message_Flag,
  INT_ *n_Opt_Param_Strings_Ptr,
  INT_ *Opt_Flag,
  INT_ Set_Arg_Flag,
  INT_ Set_Param_Flag,
  UG_Param_Struct * UG_Param_Struct_Ptr);

INT_ ug_set_params_from_arg
 (char **argv,
  int argc,
  INT_ Ignore_Error_Flag,
  INT_ Message_Flag,
  UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Search the input arguments for UG parameters to read and re-set.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_set_params_from_arg.c,v 1.14 2023/06/23 16:37:27 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  char *Next_Param_String_Ptr = NULL;
  char *Opt_Param_Strings_Ptr = NULL;
  char *Param_Name_Ptr = NULL;
  char *Param_String_Ptr = NULL;
  char *String_Ptr = NULL;
  char *String_Ptr_2 = NULL;
  char *String_String_Ptr = NULL;
  char *Sub_String_Ptr = NULL;

  CHAR_81 Text;

  int arg;
  INT_ ierr, Length, Opt_Param, 
       n_Opt_Param_Strings_Ptr, n_Param_String_Ptr, n_Param_String_Ptr2,
       n_String_Ptr, n_String_Ptr2, n_Sub_String_Ptr, n_Sub_String_Ptr2; 
  INT_ Error_Flag = 0;
  INT_ Opt_Flag = 0;
  INT_ Param_Error_Flag = 0;
  INT_ Set_Arg_Flag = 0;
  INT_ Set_Param_Flag = 1;

  if (UG_Param_Struct_Ptr == NULL)
    return (0);
  else if (argc == 1)
    return (0);

  ierr = 0;

  n_Opt_Param_Strings_Ptr = UG_MAX_CHAR_STRING_LENGTH-1;
  n_String_Ptr = UG_MAX_CHAR_STRING_LENGTH-1;
  n_Sub_String_Ptr = UG_MAX_CHAR_STRING_LENGTH-1;

  Opt_Param_Strings_Ptr = (char *) ug_malloc (&ierr, (n_Opt_Param_Strings_Ptr+1) * sizeof (char));
  String_Ptr = (char *) ug_malloc (&ierr, (n_String_Ptr+1) * sizeof (char));
  String_Ptr_2 = (char *) ug_malloc (&ierr, (n_String_Ptr+1) * sizeof (char));
  Sub_String_Ptr = (char *) ug_malloc (&ierr, (n_Sub_String_Ptr+1) * sizeof (char));

  if (ierr)
  {
    ug_free (Opt_Param_Strings_Ptr);
    ug_free (String_Ptr);
    ug_free (String_Ptr_2);
    ug_free (Sub_String_Ptr);
    ug_error_message ("*** ERROR 100446 : unable to allocate space for temporary strings ***");
    return (100446);
  }

  if (Message_Flag > 0)
  {
    ug_message (" ");
    ug_message ("UG PARAM : SETTING INPUT PARAMETERS FROM ARGUMENT VECTOR");
    ug_message (" ");
  }

  arg = 1;

  do
  {
    strcpy (Opt_Param_Strings_Ptr, "");

    Opt_Flag = 0;
    Opt_Param = 0;

    do
    {
      ierr = 0;

      n_Param_String_Ptr = MAX ((INT_) strlen (argv[arg]), UG_MAX_CHAR_STRING_LENGTH-1);

      Param_String_Ptr = (char *) ug_malloc (&ierr, (n_Param_String_Ptr+1) * sizeof (char));

      if (arg+1 < argc)
        Next_Param_String_Ptr = (char *) ug_malloc (&ierr, (strlen (argv[arg+1]) + 1) * sizeof (char));
      else
        Next_Param_String_Ptr = (char *) ug_malloc (&ierr, sizeof (char));

      if (ierr)
      {
        ug_free (Next_Param_String_Ptr);
        ug_free (Opt_Param_Strings_Ptr);
        ug_free (Param_Name_Ptr);
        ug_free (Param_String_Ptr);
        ug_free (String_Ptr);
        ug_free (String_Ptr_2);
        ug_free (Sub_String_Ptr);
        ug_error_message ("*** ERROR 100447 : unable to allocate space for temporary strings ***");
        return (100447);
      }

      if (Opt_Flag == 0)
      {
        strcpy (Param_String_Ptr, "");

        strcpy (Next_Param_String_Ptr, "");

        strcpy (Param_String_Ptr, argv[arg]);

        if (arg+1 < argc)
          strcpy (Next_Param_String_Ptr, argv[arg+1]);
      }

      else
      {
        if (Opt_Param == 0)
        {
          ierr = 0;

          n_String_Ptr2 = (INT_) strlen (Opt_Param_Strings_Ptr);

          if (n_String_Ptr2 > n_String_Ptr)
          {
            n_String_Ptr = n_String_Ptr2;

            String_Ptr = (char *) ug_realloc (&ierr, String_Ptr, (n_String_Ptr+1) * sizeof (char));
            String_Ptr_2 = (char *) ug_realloc (&ierr, String_Ptr_2, (n_String_Ptr+1) * sizeof (char));
          }

          n_Sub_String_Ptr2 = (INT_) strlen (Opt_Param_Strings_Ptr);

          if (n_Sub_String_Ptr2 > n_Sub_String_Ptr)
          {
            n_Sub_String_Ptr = n_Sub_String_Ptr2;

            Sub_String_Ptr = (char *) ug_realloc (&ierr, Sub_String_Ptr, (n_Sub_String_Ptr+1) * sizeof (char));
          }

          if (ierr)
          {
            ug_free (Next_Param_String_Ptr);
            ug_free (Opt_Param_Strings_Ptr);
            ug_free (Param_Name_Ptr);
            ug_free (Param_String_Ptr);
            ug_free (String_Ptr);
            ug_free (String_Ptr_2);
            ug_free (Sub_String_Ptr);
            ug_error_message ("*** ERROR 100448 : unable to reallocate space for temporary strings ***");
            return (100448);
          }

          strcpy (String_Ptr, Opt_Param_Strings_Ptr);
        }

        Length = (INT_) strcspn (String_Ptr, " ");

        if (Length)
        {
          strcpy (Sub_String_Ptr, "");

          strncat (Sub_String_Ptr, String_Ptr, Length);

          strcpy (Param_String_Ptr, "");

          n_Param_String_Ptr2 = (INT_) strlen (Sub_String_Ptr);

          if (n_Param_String_Ptr2 > n_Param_String_Ptr)
          {
            n_Param_String_Ptr = n_Param_String_Ptr2;

            ierr = 0;

            Param_String_Ptr = (char *) ug_realloc (&ierr, Param_String_Ptr, (n_Param_String_Ptr+1) * sizeof (char));

            if (ierr)
            {
              ug_free (Next_Param_String_Ptr);
              ug_free (Opt_Param_Strings_Ptr);
              ug_free (Param_Name_Ptr);
              ug_free (Param_String_Ptr);
              ug_free (String_Ptr);
              ug_free (String_Ptr_2);
              ug_free (Sub_String_Ptr);
              ug_error_message ("*** ERROR 100449 : unable to reallocate space for temporary strings ***");
              return (100449);
            }
          }

          strcpy (Param_String_Ptr, Sub_String_Ptr);

          strcpy (Next_Param_String_Ptr, "");

          ++Opt_Param;

          String_String_Ptr = strstr (String_Ptr, " ");

          if (String_String_Ptr)
          {
            if (strlen (String_String_Ptr) > 1)
            {
              ++String_String_Ptr;

              strcpy (String_Ptr_2, String_String_Ptr);
              strcpy (String_Ptr, String_Ptr_2);
            }
            else
              strcpy (String_Ptr, "");
          }
          else
            strcpy (String_Ptr, "");
        }
        else
          strcpy (Param_String_Ptr, "");
      }

      if (strcmp (Param_String_Ptr, ""))
      {
        Error_Flag = ug_set_param_from_string (&argv, &Opt_Param_Strings_Ptr, &Param_Name_Ptr,
                                               Param_String_Ptr, Next_Param_String_Ptr,
                                               &argc, Message_Flag, &n_Opt_Param_Strings_Ptr,
                                               &Opt_Flag, Set_Arg_Flag, Set_Param_Flag,
                                               UG_Param_Struct_Ptr);

        if (Ignore_Error_Flag) Error_Flag = 0;

        if (Error_Flag == -6 && (Opt_Flag == 0 || (Opt_Flag == 3 && Opt_Param == 0)))
        {
          ++arg;

          Error_Flag = 0;
        }

        if (Error_Flag == -2)
        {
          snprintf (Text, sizeof(Text), "UG PARAM : %-28s= UNREADABLE PARAMETER STRING", Param_String_Ptr);
          ug_error_message (Text);
        }

        else if (Error_Flag == -3)
        {
          snprintf (Text, sizeof(Text), "UG PARAM : %-28s= UNKNOWN PARAMETER NAME", Param_String_Ptr);
          ug_error_message (Text);
        }

        else if (Error_Flag == -4 || Error_Flag == -5)
        {
          snprintf (Text, sizeof(Text), "UG PARAM : %-28s= PARAMETER VALUE MISSING", Param_String_Ptr);
          ug_error_message (Text);
        }

        if (Error_Flag < -1)
          ++Param_Error_Flag;

        Error_Flag = MAX (Error_Flag, 0);
      }
      else
        Opt_Flag = 0;

      ug_free (Param_String_Ptr);
      ug_free (Next_Param_String_Ptr);

      Param_String_Ptr = NULL;
      Next_Param_String_Ptr = NULL;
    }
    while (Error_Flag == 0 && Opt_Flag);

    ++arg;
  }
  while (arg < argc && Error_Flag == 0);

  ug_free (Opt_Param_Strings_Ptr);
  ug_free (Param_Name_Ptr);
  ug_free (String_Ptr);
  ug_free (String_Ptr_2);
  ug_free (Sub_String_Ptr);

  if (Error_Flag == 0 && Param_Error_Flag)
  {
    ug_error_message ("*** ERROR 434: error in input parameters ***");
    return (434);
  }

  return (Error_Flag);

}

INT_ ug_set_param_from_string
 (char ***argv,
  char **Opt_Param_Strings_Ptr,
  char **Param_Name_Ptr,
  char *Param_String_Ptr,
  char *Next_Param_String_Ptr,
  int *argc,
  INT_ Message_Flag,
  INT_ *n_Opt_Param_Strings_Ptr,
  INT_ *Opt_Flag,
  INT_ Set_Arg_Flag,
  INT_ Set_Param_Flag,
  UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Set a UG parameter from a given string.
 */

  char *Char_Param_Value_Ptr = NULL;
  char *Name_Ptr = NULL;
  char *String_Ptr = NULL;
  char *Value_Ptr = NULL;

  static INT_1D *Int_Param_Vector = NULL;
  static DOUBLE_1D *Double_Param_Vector = NULL;
  static INT_ Entries = 0;
  static INT_ Index = 0;
  static INT_ Param_Type_Flag = 0;

  INT_ Error_Flag, ierr, Int_Param_Value, Message_Flag_,
       n_Opt_Param_Strings_Ptr2, Next_Param_Flag;

  double Double_Param_Value;

  ierr = 0;

  // reset vector flags and return
  // if last vector parameter was not fully set then return with error

  if (strcmp (Param_String_Ptr, "RESET") == 0)
  {
    ug_free (Double_Param_Vector);
    ug_free (Int_Param_Vector);

    Double_Param_Vector = NULL;
    Int_Param_Vector = NULL;

    if (Param_Type_Flag)
    {
      ug_error_message ("*** ERROR 409 : error processing input parameters ***");
      return (409);
    }

    Entries = 0;

    Param_Type_Flag = 0;

    return (0);
  }

  if (Param_Type_Flag != -DOUBLE_PARAM_VECTOR_TYPE_FLAG && Param_Type_Flag != -INT_PARAM_VECTOR_TYPE_FLAG)
    Param_Type_Flag = 0;

  if (strstr (Param_String_Ptr, "=") || strcmp (Next_Param_String_Ptr, "") == 0 || Param_Type_Flag == -DOUBLE_PARAM_VECTOR_TYPE_FLAG || Param_Type_Flag == -INT_PARAM_VECTOR_TYPE_FLAG)
  {
    String_Ptr = (char *) ug_malloc (&ierr, (strlen (Param_String_Ptr) + 1) * sizeof (char));

    if (ierr == 0)
      strcpy (String_Ptr, Param_String_Ptr);

    Next_Param_Flag = 0;
  }
  else
  {
    String_Ptr = (char *) ug_malloc (&ierr, (strlen (Param_String_Ptr) + 1 + strlen (Next_Param_String_Ptr) + 1) * sizeof (char));

    if (ierr == 0)
    {
      strcpy (String_Ptr, Param_String_Ptr);
      strcat (String_Ptr, " ");
      strcat (String_Ptr, Next_Param_String_Ptr);
    }

    Next_Param_Flag = 1;
  }

  Name_Ptr = (char *) ug_malloc (&ierr, (strlen (String_Ptr) + 1) * sizeof (char));
  Value_Ptr = (char *) ug_malloc (&ierr, (strlen (String_Ptr) + 1) * sizeof (char));

  if (ierr)
  {
    ug_free (Name_Ptr);
    ug_free (String_Ptr);
    ug_free (Value_Ptr);
    ug_error_message ("*** ERROR 100437 : unable to allocate space for temporary string ***");
    return (100437);
  }

  Error_Flag = ug_get_param_name_from_string (String_Ptr, Name_Ptr, Value_Ptr);

  ug_free (String_Ptr);

  String_Ptr = NULL;

  if (Error_Flag == -4 && (Param_Type_Flag == -DOUBLE_PARAM_VECTOR_TYPE_FLAG || Param_Type_Flag == -INT_PARAM_VECTOR_TYPE_FLAG))
  {
    strcpy (Value_Ptr, "");
    strcat (Value_Ptr, Name_Ptr);

    Error_Flag = 0;
  }

  if (Error_Flag == -4 || Error_Flag == -5)
    strcpy (Param_String_Ptr, Name_Ptr);

  if (Error_Flag != 0 && Error_Flag != -4 && Error_Flag != -5)
  {
    ug_free (Name_Ptr);
    ug_free (Value_Ptr);
    return (Error_Flag);
  }

  if (! Param_Type_Flag)
  {
    ug_free (*Param_Name_Ptr);

    *Param_Name_Ptr = (char *) ug_malloc (&ierr, (strlen (Name_Ptr) + 1) * sizeof (char));

    if (ierr)
    {
      ug_free (*Param_Name_Ptr);
      *Param_Name_Ptr = NULL;
      ug_error_message ("*** ERROR 100438 : unable to allocate space for temporary string ***");
      return (100438);
    }

    strcpy (*Param_Name_Ptr, Name_Ptr);
  }

  if (! Param_Type_Flag)
  {
    Index = 0;

    do
    {
      if (ug_get_param_name_from_alt_names (UG_Param_Struct_Ptr->Char_Param_Name[Index], UG_Param_Struct_Ptr->Char_Param_Alt_Name[Index], Name_Ptr))
        Param_Type_Flag = CHAR_PARAM_TYPE_FLAG;

      ++Index;
    }
    while (Index < UG_Param_Struct_Ptr->Number_of_Char_Params && ! Param_Type_Flag);

    --Index;

    if (Param_Type_Flag && UG_Param_Struct_Ptr->Char_Param_Type[Index] == 2)
      Param_Type_Flag = OPT_PARAM_TYPE_FLAG;
    else if (Param_Type_Flag && UG_Param_Struct_Ptr->Char_Param_Type[Index] == 3)
      Param_Type_Flag = OPT_VALUE_PARAM_TYPE_FLAG;
  }

  if (! Param_Type_Flag)
  {
    Index = 0;

    do
    {
      if (ug_get_param_name_from_alt_names (UG_Param_Struct_Ptr->Double_Param_Name[Index], UG_Param_Struct_Ptr->Double_Param_Alt_Name[Index], Name_Ptr))
        Param_Type_Flag = DOUBLE_PARAM_TYPE_FLAG;

      ++Index;
    }
    while (Index < UG_Param_Struct_Ptr->Number_of_Double_Params && ! Param_Type_Flag);

    --Index;

    if (Param_Type_Flag && UG_Param_Struct_Ptr->Double_Param_Vector_Entries[Index] >= 0)
      Param_Type_Flag = DOUBLE_PARAM_VECTOR_TYPE_FLAG;
  }

  if (! Param_Type_Flag)
  {
    Index = 0;

    do
    {
      if (ug_get_param_name_from_alt_names (UG_Param_Struct_Ptr->Int_Param_Name[Index], UG_Param_Struct_Ptr->Int_Param_Alt_Name[Index], Name_Ptr))
        Param_Type_Flag = INT_PARAM_TYPE_FLAG;

      ++Index;
    }
    while (Index < UG_Param_Struct_Ptr->Number_of_Int_Params && ! Param_Type_Flag);

    --Index;

    if (Param_Type_Flag && UG_Param_Struct_Ptr->Int_Param_Vector_Entries[Index] >= 0)
      Param_Type_Flag = INT_PARAM_VECTOR_TYPE_FLAG;
  }

  if (! Param_Type_Flag)
  {
    strcpy (Param_String_Ptr, Name_Ptr);
    ug_free (Name_Ptr);
    ug_free (Value_Ptr);
    return (-3);
  }

  if (Param_Type_Flag && (Error_Flag == -4 || Error_Flag == -5) && Param_Type_Flag == OPT_PARAM_TYPE_FLAG)
    Error_Flag = 0;

  if (Error_Flag != 0)
  {
    ug_free (Name_Ptr);
    ug_free (Value_Ptr);
    return (Error_Flag);
  }

  Char_Param_Value_Ptr = (char *) ug_malloc (&ierr, (strlen (Value_Ptr) + 1) * sizeof (char));

  if (ierr)
  {
    ug_free (Char_Param_Value_Ptr);
    ug_error_message ("*** ERROR 100439 : unable to allocate space for temporary string ***");
    return (100439);
  }

  Error_Flag = ug_get_param_from_value (Char_Param_Value_Ptr, Value_Ptr,
                                        &Entries, &Int_Param_Value, &Param_Type_Flag, &Int_Param_Vector,
                                        &Double_Param_Value, &Double_Param_Vector);

  if (Error_Flag == 0)
  {
    if (Param_Type_Flag == CHAR_PARAM_TYPE_FLAG)
    {
      if (Set_Param_Flag)
      {
        Message_Flag_ = (UG_Param_Struct_Ptr->Char_Param_Rank[Index]) ? Message_Flag: 0;

        ug_set_char_param_ (Index, Message_Flag_, Char_Param_Value_Ptr, UG_Param_Struct_Ptr);
      }

      if (Set_Arg_Flag)
      {
        Error_Flag = ug_add_flag_arg (*Param_Name_Ptr, argc, argv);
        Error_Flag = ug_add_flag_arg (Char_Param_Value_Ptr, argc, argv);

        ug_free (*Param_Name_Ptr);

        *Param_Name_Ptr = NULL;
      }
    }

    else if (Param_Type_Flag == DOUBLE_PARAM_TYPE_FLAG)
    {
      if (Set_Param_Flag)
      {
        Message_Flag_ = (UG_Param_Struct_Ptr->Double_Param_Rank[Index]) ? Message_Flag: 0;

        ug_set_double_param_ (Index, Message_Flag_, Double_Param_Value, UG_Param_Struct_Ptr);
      }

      if (Set_Arg_Flag)
      {
        Error_Flag = ug_add_flag_arg (*Param_Name_Ptr, argc, argv);
        Error_Flag = ug_add_double_arg (Double_Param_Value, argc, argv);

        ug_free (*Param_Name_Ptr);

        *Param_Name_Ptr = NULL;
      }
    }

    else if (Param_Type_Flag == INT_PARAM_TYPE_FLAG)
    {
      if (Set_Param_Flag)
      {
        Message_Flag_ = (UG_Param_Struct_Ptr->Int_Param_Rank[Index]) ? Message_Flag: 0;

        ug_set_int_param_ (Index, Message_Flag_, Int_Param_Value, UG_Param_Struct_Ptr);
      }

      if (Set_Arg_Flag)
      {
        Error_Flag = ug_add_flag_arg (*Param_Name_Ptr, argc, argv);
        Error_Flag = ug_add_int_arg (Int_Param_Value, argc, argv);

        ug_free (*Param_Name_Ptr);

        *Param_Name_Ptr = NULL;
      }
    }

    else if (Param_Type_Flag == DOUBLE_PARAM_VECTOR_TYPE_FLAG)
    {
      if (Set_Param_Flag)
      {
        Message_Flag_ = (UG_Param_Struct_Ptr->Double_Param_Rank[Index]) ? Message_Flag: 0;

        Error_Flag = ug_set_double_param_vector_ (Index, Message_Flag_, Entries, Double_Param_Vector, UG_Param_Struct_Ptr);
      }

      if (Error_Flag == 0 && Set_Arg_Flag)
      {
        Error_Flag = ug_add_flag_arg (*Param_Name_Ptr, argc, argv);
        Error_Flag = ug_add_double_vector_arg (Entries, Double_Param_Vector, argc, argv);

        ug_free (*Param_Name_Ptr);

        *Param_Name_Ptr = NULL;
      }
    }

    else if (Param_Type_Flag == INT_PARAM_VECTOR_TYPE_FLAG)
    {
      if (Set_Param_Flag)
      {
        Message_Flag_ = (UG_Param_Struct_Ptr->Int_Param_Rank[Index]) ? Message_Flag: 0;

        Error_Flag = ug_set_int_param_vector_ (Index, Message_Flag_, Entries, Int_Param_Vector, UG_Param_Struct_Ptr);
      }

      if (Error_Flag == 0 && Set_Arg_Flag)
      {
        Error_Flag = ug_add_flag_arg (*Param_Name_Ptr, argc, argv);
        Error_Flag = ug_add_int_vector_arg (Entries, Int_Param_Vector, argc, argv);

        ug_free (*Param_Name_Ptr);

        *Param_Name_Ptr = NULL;
      }
    }

    else if (Param_Type_Flag == OPT_PARAM_TYPE_FLAG)
    {
      if (*Opt_Flag == 0)
      {
        Next_Param_Flag = 0;

        *Opt_Flag = 2;

        strcpy (*Opt_Param_Strings_Ptr, "");
        strcpy (*Opt_Param_Strings_Ptr, UG_Param_Struct_Ptr->Def_Char_Param[Index]);
      }
      else
        Error_Flag = 411;
    }

    else if (Param_Type_Flag == OPT_VALUE_PARAM_TYPE_FLAG)
    {
      if (*Opt_Flag == 0)
      {
        *Opt_Flag = 3;

        ierr = 0;

        n_Opt_Param_Strings_Ptr2 = (INT_) (strlen (UG_Param_Struct_Ptr->Def_Char_Param[Index]) + strlen (Char_Param_Value_Ptr));

        if (n_Opt_Param_Strings_Ptr2 > *n_Opt_Param_Strings_Ptr) 
        {
          *n_Opt_Param_Strings_Ptr = n_Opt_Param_Strings_Ptr2;

          *Opt_Param_Strings_Ptr = (char *) ug_realloc (&ierr, *Opt_Param_Strings_Ptr, (*n_Opt_Param_Strings_Ptr+1) * sizeof (char));

          if (ierr)
          {
            ug_error_message ("*** ERROR 100440 : unable to allocate space for parameter string ***");
            return (100440);
          }
        }

        strcpy (*Opt_Param_Strings_Ptr, "");
        strcpy (*Opt_Param_Strings_Ptr, UG_Param_Struct_Ptr->Def_Char_Param[Index]);
        strcat (*Opt_Param_Strings_Ptr, Char_Param_Value_Ptr);
      }
      else
        Error_Flag = 411;
    }
  }

  ug_free (Char_Param_Value_Ptr);
  ug_free (Name_Ptr);
  ug_free (Value_Ptr);

  if (Error_Flag != 0 || Param_Type_Flag != -DOUBLE_PARAM_VECTOR_TYPE_FLAG)
  {
    ug_free (Double_Param_Vector);
    Double_Param_Vector = NULL;
  }

  if (Error_Flag != 0 || Param_Type_Flag != -INT_PARAM_VECTOR_TYPE_FLAG)
  {
    ug_free (Int_Param_Vector);

    Int_Param_Vector = NULL;
  }

  if (Error_Flag != 0 || (Param_Type_Flag != -DOUBLE_PARAM_VECTOR_TYPE_FLAG && Param_Type_Flag != -INT_PARAM_VECTOR_TYPE_FLAG))
  {
    Entries = 0;
    Param_Type_Flag = 0;
  }

  if (Error_Flag == 0 && Next_Param_Flag == 1)
    Error_Flag = -6;

  return (Error_Flag);

}
