#include "UG_LIB.h"

void ug_set_param_inp
 (UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Set @inp values for UG parameter variables to values currently set.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_set_param_inp.c,v 1.2 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum 
 */

  INT_ Index;

  for (Index = 0; Index < UG_Param_Struct_Ptr->Number_of_Int_Params; ++Index)
  {
    if ((UG_Param_Struct_Ptr->Int_Param_Vector_Entries)[Index] == -1)
      (UG_Param_Struct_Ptr->Inp_Int_Param)[Index] = (UG_Param_Struct_Ptr->Int_Param)[Index];
  }

  for (Index = 0; Index < UG_Param_Struct_Ptr->Number_of_Double_Params; ++Index)
  {
    if ((UG_Param_Struct_Ptr->Double_Param_Vector_Entries)[Index] == -1)
      (UG_Param_Struct_Ptr->Inp_Double_Param)[Index] = (UG_Param_Struct_Ptr->Double_Param)[Index];
  }

  return;

}
