#include "UG_LIB.h"

INT_ ug_set_int_param_struct
 (char Int_Param_Name_[],
  char Int_Param_Alt_Name_[],
  char Int_Param_Info_[],
  char Int_Param_Doc_[],
  INT_ Int_Param_Rank_,
  INT_ Vector_Flag,
  INT_ Def_Int_Param_,
  INT_ Min_Int_Param_,
  INT_ Max_Int_Param_,
  UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Set and initialize param structure for a given Int_Param.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_set_int_param_struct.c,v 1.12 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */


  INT_ Error_Flag, Index;

  Index = UG_Param_Struct_Ptr->Number_of_Int_Params;

  UG_Param_Struct_Ptr->Number_of_Int_Params = Index + 1;

  if (Index >= UG_Param_Struct_Ptr->Max_Int_Params)
  {
    Error_Flag = ug_realloc_param (UG_Param_Struct_Ptr);

    if (Error_Flag > 0)
      return (Error_Flag);
  }

  Error_Flag = 0;

  UG_Param_Struct_Ptr->Int_Param_Doc[Index] = (char *) ug_malloc (&Error_Flag, (strlen (Int_Param_Doc_)+1) * (sizeof (char)));

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 100420 : unable to allocate required memory ***");
    return (100420);
  }

  strcpy (UG_Param_Struct_Ptr->Int_Param_Name[Index], Int_Param_Name_);
  strcpy (UG_Param_Struct_Ptr->Int_Param_Alt_Name[Index], Int_Param_Alt_Name_);
  UG_Param_Struct_Ptr->Int_Param_Rank[Index] = Int_Param_Rank_;
  strcpy (UG_Param_Struct_Ptr->Int_Param_Info[Index], Int_Param_Info_);
  strcpy (UG_Param_Struct_Ptr->Int_Param_Doc[Index], Int_Param_Doc_);
  UG_Param_Struct_Ptr->Def_Int_Param[Index] = Def_Int_Param_;
  UG_Param_Struct_Ptr->Min_Int_Param[Index] = Min_Int_Param_;
  UG_Param_Struct_Ptr->Max_Int_Param[Index] = Max_Int_Param_;
  UG_Param_Struct_Ptr->Int_Param_Vector_Entries[Index] = (Vector_Flag) ? 0: -1;
  UG_Param_Struct_Ptr->Int_Param_Vector_Loc[Index] = 0;

  return (0);
}
