#include "UG_LIB.h"

INT_ ug_set_double_param_struct
 (char Double_Param_Name_[],
  char Double_Param_Alt_Name_[],
  char Double_Param_Info_[],
  char Double_Param_Doc_[],
  INT_ Double_Param_Rank_,
  INT_ Vector_Flag,
  double Def_Double_Param_,
  double Min_Double_Param_,
  double Max_Double_Param_,
  UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Set and initialize param structure for a given Double_Param.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_set_double_param_struct.c,v 1.13 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag, Index;

  Index = UG_Param_Struct_Ptr->Number_of_Double_Params;

  UG_Param_Struct_Ptr->Number_of_Double_Params = Index + 1;

  if (Index >= UG_Param_Struct_Ptr->Max_Double_Params)
  {
    Error_Flag = ug_realloc_param (UG_Param_Struct_Ptr);

    if (Error_Flag > 0)
      return (Error_Flag);
  }

  Error_Flag = 0;

  UG_Param_Struct_Ptr->Double_Param_Doc[Index] = (char *) ug_malloc (&Error_Flag, (strlen (Double_Param_Doc_)+1) * (sizeof (char)));

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 100419 : unable to allocate required memory ***");
    return (100419);
  }

  strcpy (UG_Param_Struct_Ptr->Double_Param_Name[Index], Double_Param_Name_);
  strcpy (UG_Param_Struct_Ptr->Double_Param_Alt_Name[Index], Double_Param_Alt_Name_);
  strcpy (UG_Param_Struct_Ptr->Double_Param_Info[Index], Double_Param_Info_);
  strcpy (UG_Param_Struct_Ptr->Double_Param_Doc[Index], Double_Param_Doc_);
  UG_Param_Struct_Ptr->Def_Double_Param[Index] = Def_Double_Param_;
  UG_Param_Struct_Ptr->Min_Double_Param[Index] = Min_Double_Param_;
  UG_Param_Struct_Ptr->Max_Double_Param[Index] = Max_Double_Param_;
  UG_Param_Struct_Ptr->Double_Param_Rank[Index] = Double_Param_Rank_;
  UG_Param_Struct_Ptr->Double_Param_Vector_Entries[Index] = (Vector_Flag) ? 0: -1;
  UG_Param_Struct_Ptr->Double_Param_Vector_Loc[Index] = 0;

  return (0);
}
