#include "UG_LIB.h"

INT_ ug_set_char_param_struct
 (char Char_Param_Name_[],
  char Char_Param_Alt_Name_[],
  char Char_Param_Info_[],
  char Char_Param_Doc_[],
  char Def_Char_Param_[],
  INT_ Char_Param_Rank_,
  INT_ Char_Param_Type_,
  UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Set and initialize param structure for a given Char_Param.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_set_char_param_struct.c,v 1.11 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag, Index;

  Index = UG_Param_Struct_Ptr->Number_of_Char_Params;

  UG_Param_Struct_Ptr->Number_of_Char_Params = Index + 1;

  if (Index >= UG_Param_Struct_Ptr->Max_Char_Params)
  {
    Error_Flag = ug_realloc_param (UG_Param_Struct_Ptr);

    if (Error_Flag > 0)
      return (Error_Flag);
  }

  Error_Flag = 0;

  UG_Param_Struct_Ptr->Char_Param_Doc[Index] = (char *) ug_malloc (&Error_Flag, (strlen (Char_Param_Doc_)+1) * (sizeof (char)));

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 100418 : unable to allocate required memory ***");
    return (100418);
  }

  strcpy (UG_Param_Struct_Ptr->Char_Param_Name[Index], Char_Param_Name_);
  strcpy (UG_Param_Struct_Ptr->Char_Param_Alt_Name[Index], Char_Param_Alt_Name_);
  strcpy (UG_Param_Struct_Ptr->Char_Param_Info[Index], Char_Param_Info_);
  strcpy (UG_Param_Struct_Ptr->Char_Param_Doc[Index], Char_Param_Doc_);
  strcpy (UG_Param_Struct_Ptr->Def_Char_Param[Index], Def_Char_Param_);
  UG_Param_Struct_Ptr->Char_Param_Rank[Index] = Char_Param_Rank_;
  UG_Param_Struct_Ptr->Char_Param_Type[Index] = Char_Param_Type_;

  return (0);
}
