#include "UG_LIB.h"

// This routine is in ug_set_params_from_arg and not intended to be called
// outside of ug_read_param_file and ug_set_params_from_arg.

INT_ ug_set_param_from_string
 (char ***argv,
  char **Opt_Param_Strings_Ptr,
  char **Param_Name_Ptr,
  char *Param_String_Ptr,
  char *Next_Param_String_Ptr,
  int *argc,
  INT_ Message_Flag,
  INT_ *n_Opt_Param_Strings_Ptr,
  INT_ *Opt_Flag,
  INT_ Set_Arg_Flag,
  INT_ Set_Param_Flag,
  UG_Param_Struct * UG_Param_Struct_Ptr);

INT_ ug_read_param_file
 (char ***argv,
  int *argc,
  INT_ Message_Flag,
  UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Read an input parameter file (*.par) and set the input argument vector.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_read_param_file.c,v 1.11 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Param_File;

  char *Next_Param_String_Ptr = NULL;
  char *Opt_Param_Strings_Ptr = NULL;
  char *Param_Name_Ptr = NULL;
  char *Param_String_Ptr = NULL;
  char *Read_Label = NULL;
  char *String_Ptr = NULL;
  char *String_Ptr_2 = NULL;
  char *String_String_Ptr = NULL;
  char *Sub_String_Ptr = NULL;

  CHAR_UG_MAX Param_File_Name;
  CHAR_81 Text;

  INT_ EOF_Flag, Length, Opt_Param, 
       n_Opt_Param_Strings_Ptr, n_Param_String_Ptr, n_Param_String_Ptr2,
       n_String_Ptr, n_String_Ptr2, n_Sub_String_Ptr, n_Sub_String_Ptr2; 
  INT_ Error_Flag = 0;
  INT_ Opt_Flag = 0;
  INT_ Param_Error_Flag = 0;
  INT_ Set_Arg_Flag = 1;
  INT_ Set_Param_Flag = 0;

  int i, j;

  if (UG_Param_Struct_Ptr == NULL)
    return (0);
  else if (*argc == 1)
    return (0);

  strcpy (Param_File_Name, "");

  // set parameter file name if it is the first argument and set argument to ?

  String_Ptr = strstr ((*argv)[1], ".par");

  if (String_Ptr)
  {
    if (strcmp (String_Ptr, ".par") == 0)
    {
      strcpy (Param_File_Name, (*argv)[1]);
      strcpy ((*argv)[1], "?");
    }
  }

  // set parameter file name if it is specified in the argument vector and
  // set related arguments to ?

  for (i = 1; i < *argc-1; ++i)
  {
    if (strcmp ((*argv)[i], "Param_File_Name") == 0 ||
        strcmp ((*argv)[i], "-Param_File_Name") == 0 ||
        strcmp ((*argv)[i], "par") == 0 ||
        strcmp ((*argv)[i], "-par") == 0)
    {
      strcpy (Param_File_Name, (*argv)[i+1]);
      strcpy ((*argv)[i], "?");
      strcpy ((*argv)[i+1], "?");
    }
  }

  // return if argument file name was not specified in argument vector

  if (strcmp (Param_File_Name, "") == 0)
    return (0);

  // remove parameter file related arguments

  j = 0;

  for (i = 1; i < *argc; ++i)
  {
    if (strcmp ((*argv)[i], "?"))
    {
      ++j;

      if (j < i)
      {
        (*argv)[j] = (char *) ug_realloc (&Error_Flag, (*argv)[j], (strlen ((*argv)[i]) + 1) * sizeof (char));

        if (Error_Flag)
        {
          ug_error_message ("*** ERROR 100444 : unable to allocate space for argument vector ***");
          return (100444);
        }

        strcpy ((*argv)[j], (*argv)[i]);
      }
    }
  }

  for (i = j+1; i < *argc; ++i)
  {
    ug_free ((*argv)[i]);

    (*argv)[i] = NULL;
  }

  *argc = j+1;

  // write message

  if (Message_Flag > 0)
  {
    ug_message (" ");
    ug_message ("UG PARAM : READING PARAM FILE");
    ug_message (" ");

    strcpy (Text, "UG PARAM : PARAM File Name = ");
    strncat (Text, Param_File_Name, 80-strlen(Text));
    ug_message (Text);
  }

  // allocate space for temporary strings

  n_Opt_Param_Strings_Ptr = UG_MAX_CHAR_STRING_LENGTH-1;
  n_String_Ptr = UG_MAX_CHAR_STRING_LENGTH-1;
  n_Sub_String_Ptr = UG_MAX_CHAR_STRING_LENGTH-1;

  Opt_Param_Strings_Ptr = (char *) ug_malloc (&Error_Flag, (n_Opt_Param_Strings_Ptr+1) * sizeof (char));
  String_Ptr = (char *) ug_malloc (&Error_Flag, (n_String_Ptr+1) * sizeof (char));
  String_Ptr_2 = (char *) ug_malloc (&Error_Flag, (n_String_Ptr+1) * sizeof (char));
  Sub_String_Ptr = (char *) ug_malloc (&Error_Flag, (n_Sub_String_Ptr+1) * sizeof (char));

  if (Error_Flag)
  {
    ug_free (Opt_Param_Strings_Ptr);
    ug_free (String_Ptr);
    ug_free (String_Ptr_2);
    ug_free (Sub_String_Ptr);
    ug_error_message ("*** ERROR 100432 : unable to allocate space for temporary strings ***");
    return (100432);
  }

  // open parameter file

  Param_File = ug_fopen (Param_File_Name, "r");

  if (Param_File == NULL)
  {
    ug_free (Opt_Param_Strings_Ptr);
    ug_free (String_Ptr);
    ug_free (String_Ptr_2);
    ug_free (Sub_String_Ptr);
    ug_error_message ("*** ERROR 413 : error opening input parameter file ***");
    return (413);
  }

  // read parameter file and set related arguments

  do
  {
    strcpy (Opt_Param_Strings_Ptr, "");

    Opt_Flag = 0;
    Opt_Param = 0;

    do
    {
      n_Param_String_Ptr = UG_MAX_CHAR_STRING_LENGTH-1;

      Param_String_Ptr = (char *) ug_malloc (&Error_Flag, (n_Param_String_Ptr+1) * sizeof (char));

      Next_Param_String_Ptr = (char *) ug_malloc (&Error_Flag, sizeof (char));

      if (Error_Flag)
      {
        ug_free (Next_Param_String_Ptr);
        ug_free (Opt_Param_Strings_Ptr);
        ug_free (Param_Name_Ptr);
        ug_free (Param_String_Ptr);
        ug_free (String_Ptr);
        ug_free (String_Ptr_2);
        ug_free (Sub_String_Ptr);
        ug_error_message ("*** ERROR 100433 : unable to allocate space for temporary strings ***");
        return (100433);
      }

      if (Opt_Flag == 0)
      {
        strcpy (Param_String_Ptr, "");

        strcpy (Next_Param_String_Ptr, "");

        Read_Label = fgets (Param_String_Ptr, UG_MAX_CHAR_STRING_LENGTH-1, Param_File);
      }

      else
      {
        if (Opt_Param == 0)
        {
          n_String_Ptr2 = (INT_) strlen (Opt_Param_Strings_Ptr);

          if (n_String_Ptr2 > n_String_Ptr)
          {
            n_String_Ptr = n_String_Ptr2;

            String_Ptr = (char *) ug_realloc (&Error_Flag, String_Ptr, (n_String_Ptr+1) * sizeof (char));
            String_Ptr_2 = (char *) ug_realloc (&Error_Flag, String_Ptr_2, (n_String_Ptr+1) * sizeof (char));
          }

          n_Sub_String_Ptr2 = (INT_) strlen (Opt_Param_Strings_Ptr);

          if (n_Sub_String_Ptr2 > n_Sub_String_Ptr)
          {
            n_Sub_String_Ptr = n_Sub_String_Ptr2;

            Sub_String_Ptr = (char *) ug_realloc (&Error_Flag, Sub_String_Ptr, (n_Sub_String_Ptr+1) * sizeof (char));
          }

          if (Error_Flag)
          {
            ug_free (Next_Param_String_Ptr);
            ug_free (Opt_Param_Strings_Ptr);
            ug_free (Param_Name_Ptr);
            ug_free (Param_String_Ptr);
            ug_free (String_Ptr);
            ug_free (String_Ptr_2);
            ug_free (Sub_String_Ptr);
            ug_error_message ("*** ERROR 100434 : unable to reallocate space for temporary strings ***");
            return (100434);
          }

          strcpy (String_Ptr, Opt_Param_Strings_Ptr);
        }

        Length = (INT_) strcspn (String_Ptr, " ");

        if (Length)
        {
          strcpy (Sub_String_Ptr, "");

          strncat (Sub_String_Ptr, String_Ptr, Length);

          strcpy (Param_String_Ptr, "");

          n_Param_String_Ptr2 = (INT_) strlen (Sub_String_Ptr);

          if (n_Param_String_Ptr2 > n_Param_String_Ptr)
          {
            n_Param_String_Ptr = n_Param_String_Ptr2;

            Param_String_Ptr = (char *) ug_realloc (&Error_Flag, Param_String_Ptr, (n_Param_String_Ptr+1) * sizeof (char));

            if (Error_Flag)
            {
              ug_free (Next_Param_String_Ptr);
              ug_free (Opt_Param_Strings_Ptr);
              ug_free (Param_Name_Ptr);
              ug_free (Param_String_Ptr);
              ug_free (String_Ptr);
              ug_free (String_Ptr_2);
              ug_free (Sub_String_Ptr);
              ug_error_message ("*** ERROR 100435 : unable to reallocate space for temporary strings ***");
              return (100435);
            }
          }

          strcpy (Param_String_Ptr, Sub_String_Ptr);

          strcpy (Next_Param_String_Ptr, "");

          ++Opt_Param;

          String_String_Ptr = strstr (String_Ptr, " ");

          if (String_String_Ptr)
          {
            if (strlen (String_String_Ptr) > 1)
            {
              ++String_String_Ptr;

              strcpy (String_Ptr_2, String_String_Ptr);
              strcpy (String_Ptr, String_Ptr_2);
            }
            else
              strcpy (String_Ptr, "");
          }
          else
            strcpy (String_Ptr, "");
        }
        else
          strcpy (Param_String_Ptr, "");
      }

      if (strcmp (Param_String_Ptr, ""))
      {
        Error_Flag = ug_set_param_from_string (argv, &Opt_Param_Strings_Ptr, &Param_Name_Ptr,
                                               Param_String_Ptr, Next_Param_String_Ptr,
                                               argc, Message_Flag, &n_Opt_Param_Strings_Ptr,
                                               &Opt_Flag, Set_Arg_Flag, Set_Param_Flag,
                                               UG_Param_Struct_Ptr);

        if (Message_Flag > 0)
        {
          if (Error_Flag == -2)
          {
            snprintf (Text, sizeof(Text), "UG PARAM : %-28s= UNREADABLE PARAMETER STRING", Param_String_Ptr);
            ug_message (Text);
          }

          else if (Error_Flag == -3)
          {
            snprintf (Text, sizeof(Text), "UG PARAM : %-28s= UNKNOWN PARAMETER NAME", Param_String_Ptr);
            ug_message (Text);
          }

          else if (Error_Flag == -4 || Error_Flag == -5)
          {
            snprintf (Text, sizeof(Text), "UG PARAM : %-28s= PARAMETER VALUE MISSING", Param_String_Ptr);
            ug_message (Text);
          }
        }

        if (Error_Flag < -1)
          ++Param_Error_Flag;

        Error_Flag = MAX (Error_Flag, 0);
      }
      else
        Opt_Flag = 0;

      ug_free (Param_String_Ptr);
      ug_free (Next_Param_String_Ptr);

      Param_String_Ptr = NULL;
      Next_Param_String_Ptr = NULL;
    }
    while (Error_Flag == 0 && Opt_Flag);

    EOF_Flag = feof (Param_File);
  }
  while (EOF_Flag == 0 && Error_Flag == 0);

  ug_fclose (Param_File);

  ug_free (Opt_Param_Strings_Ptr);
  ug_free (Param_Name_Ptr);
  ug_free (String_Ptr);
  ug_free (String_Ptr_2);
  ug_free (Sub_String_Ptr);

  if (Error_Flag == 0 && Param_Error_Flag)
  {
    ug_error_message ("*** ERROR 412 : error in input parameters ***");
    return (412);
  }

  return (0);

}
