#include "UG_LIB.h"

INT_ ug_read_arg_file
 (char ***argv,
  int *argc,
  INT_ Message_Flag)

{

/*
 * Read an input argument file (*.arg) and set the input argument vector.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_read_arg_file.c,v 1.12 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Arg_File = NULL;

  char **argv_copy;
  char *String_Ptr = NULL;

  CHAR_UG_MAX Arg_File_Name;
  CHAR_81 Text;

  int argc_copy, i, j;
  INT_ Error_Flag = 0;

  if (*argc == 1)
    return (0);

  strcpy (Arg_File_Name, "");

  // set argument file name if it is the first argument and set argument to ?

  String_Ptr = strstr ((*argv)[1], ".arg");

  if (String_Ptr)
  {
    if (strcmp (String_Ptr, ".arg") == 0)
    {
      strcpy (Arg_File_Name, (*argv)[1]);
      strcpy ((*argv)[1], "?");
    }
  }

  // set argument file name if it is specified in the argument vector and
  // set related arguments to ?

  for (i = 1; i < *argc-1; ++i)
  {
    if (strcmp ((*argv)[i], "Arg_File_Name") == 0 ||
        strcmp ((*argv)[i], "-Arg_File_Name") == 0 ||
        strcmp ((*argv)[i], "arg") == 0 ||
        strcmp ((*argv)[i], "-arg") == 0)
    {
      strcpy (Arg_File_Name, (*argv)[i+1]);
      strcpy ((*argv)[i], "?");
      strcpy ((*argv)[i+1], "?");
    }
  }

  // return if argument file name was not specified in argument vector

  if (strcmp (Arg_File_Name, "") == 0)
    return (0);

  // remove parameter file related arguments

  j = 0;

  for (i = 1; i < *argc; ++i)
  {
    if (strcmp ((*argv)[i], "?"))
    {
      ++j;

      if (j < i)
      {
        (*argv)[j] = (char *) ug_realloc (&Error_Flag, (*argv)[j], (strlen ((*argv)[i]) + 1) * sizeof (char));

        if (Error_Flag)
        {
          ug_error_message ("*** ERROR 100443 : unable to allocate space for argument vector ***");
          return (100443);
        }

        strcpy ((*argv)[j], (*argv)[i]);
      }
    }
  }

  for (i = j+1; i < *argc; ++i)
  {
    ug_free ((*argv)[i]);

    (*argv)[i] = NULL;
  }

  *argc = j+1;

  // copy argument vector and save it 

  argc_copy = *argc;

  Error_Flag = ug_copy_argv (*argv, &argv_copy);

  if (Error_Flag)
  {
    ug_free_argv (argv_copy);
    return (Error_Flag);
  }

  // free original argument vector

  ug_free_argv (*argv);

  // add executable name to new argument vector

  *argc = 1;

  *argv = (char **) ug_malloc (&Error_Flag, (*argc+1) * sizeof (char *));

  if (Error_Flag == 0)
    (*argv)[0] = (char *) ug_malloc (&Error_Flag, (strlen (argv_copy[0]) + 1) * sizeof (char));

  if (Error_Flag)
  {
    ug_free_argv (argv_copy);
    ug_error_message ("*** ERROR 100436 : unable to allocate space for new argument vector ***");
    return (100436);
  }

  strcpy ((*argv)[0], argv_copy[0]);

  (*argv)[1] = NULL;

  // write message

  if (Message_Flag > 0)
  {
    ug_message (" ");
    ug_message ("UG ARG   : READING ARG FILE");
    ug_message (" ");

    strcpy (Text, "UG ARG   : ARG File Name = ");
    strncat (Text, Arg_File_Name, 80-strlen(Text));
    ug_message (Text);
  }

  // open input argument file

  Arg_File = ug_fopen (Arg_File_Name, "r");

  if (Arg_File == NULL)
  {
    ug_free_argv (argv_copy);
    ug_error_message ("*** ERROR 424 : error opening input argument file for reading ***");
    return (424);
  }

  i = 0;

  do
  {
    // allocate space for a new argument vector entry

    ++i;

    *argv = (char **) ug_realloc (&Error_Flag, *argv, (i+2) * sizeof (char *));

    if (Error_Flag)
    {
      ug_free_argv (argv_copy);
      ug_fclose (Arg_File);
      ug_error_message ("*** ERROR 100442 : unable to allocate space for new input argument vector ***");
      return (100442);
    }

    // read one line from argument file and set new argument vector entry

    Error_Flag = ug_getline (&((*argv)[i]), Arg_File);

    // set terminating null entry

    (*argv)[i+1] = NULL;
  }
  while (Error_Flag == 0);

  *argc = i;

  Error_Flag = MAX (Error_Flag, 0);

  // close argument file

  ug_fclose (Arg_File);

  // return if there was an error reading input argument file

  if (Error_Flag)
  {
    *argc = (*argc)-1;
    ug_free_argv (argv_copy);
    ug_error_message ("*** ERROR 425 : error reading input argument file ***");
    return (425);
  }

  // add original argument vector to end of new argument vector

  for (i = 1; i < argc_copy; ++i)
  {
    j = *argc + i-1;

    *argv = (char **) ug_realloc (&Error_Flag, *argv, (j+2) * sizeof (char *));

    if (Error_Flag == 0)
      (*argv)[j] = (char *) ug_malloc (&Error_Flag, (strlen (argv_copy[i]) + 1) * sizeof (char));

    if (Error_Flag)
    {
      ug_error_message ("*** ERROR 100445 : unable to allocate space for argument vector ***");
      return (100445);
    }

    strcpy ((*argv)[j], argv_copy[i]);

    // set terminating null entry

    (*argv)[j+1] = NULL;
  }

  *argc = *argc+argc_copy-1;

  // free argument vector copy

  ug_free_argv (argv_copy);

  return (0);

}
