#include "UG_LIB.h"

void ug_parse_text_string
 (INT_ prefix_length,
  char *text_string)

{

/*
 * Write input string to standard output using one or more lines of the default
 * max line length (80) or less. If a ";" is found as a word then that is
 * considered a flag to start a new line. If a "^" is found then that is
 * considered a flag to begin indenting lines 3 spaces. For each line parse all
 * words in text string using spaces or tabs to identify separate words. All 
 * lines are indented prefix_length spaces.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_parse_text_string.c,v 1.16 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_81 indent, output_text, prefix;
  char *sep = " 	"; // space and tab
  char *text=NULL;
  char *word;

  INT_ i, ierr, indent_flag, indent_length, line, line_length, max_line_length,
       new_line, next_line_new, word_length;

  indent_length = 3;
  max_line_length = 80;
  prefix_length = MAX (prefix_length, 0);

  ierr = 0;

  text = (char *) ug_malloc (&ierr, (strlen (text_string)+1) * (sizeof (char)));

  if (ierr)
  {
    ug_free (text);
    return;
  }

  strcpy (indent, "");

  for (i = 0; i < indent_length; ++i)
  {
    strcat (indent, " ");
  }

  strcpy (prefix, "");

  for (i = 0; i < prefix_length; ++i)
  {
    strcat (prefix, " ");
  }

  strcpy (text, text_string);

  strcpy (output_text, prefix);

  indent_flag = 0;

  line = 0;

  line_length = prefix_length;

  next_line_new = 0;

  for (word = strtok (text, sep); word; word = strtok (NULL, sep))
  {
    word_length = (INT_) strlen (word);

    line_length = line_length + word_length + 1; 

    new_line = (line_length > max_line_length) ? 2:
               (next_line_new) ? 1: 0;

    if (strcmp (word, ";") == 0)
    {
      next_line_new = (new_line == 2) ? 0: 1;

      strcpy (word, "");

      word_length = 0;
    }

    else if (strcmp (word, "^") == 0)
    {
      indent_flag = (indent_flag ) ? 0: 1;

      next_line_new = 0;

      strcpy (word, "");

      word_length = 0;
    }

    else
      next_line_new = 0;

    if (new_line)
    {
      ug_message (output_text);

      ++line;

      strcpy (output_text, prefix);

      line_length = prefix_length + word_length + 1;

      if (indent_flag)
      {
        strcat (output_text, indent);

        line_length = line_length + indent_length;
      }
    }

    strcat (output_text, word);

    if (word_length) strcat (output_text, " ");
  }

  if (strcmp (output_text, ""))
  {
    ug_message (output_text);

    ++line;
  }

  ug_free (text);

  return;

}
