#include "UG_LIB.h"

void ug_open_output_file
 (char *Case_Name,
  char *Program_Name,
  INT_ Output_File_Flag)

/*
 * Open UG output file and set standard output flag.
 *
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_open_output_file.c,v 1.11 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

{

  extern FILE * UG_Output_File;

  extern INT_ UG_Standard_Output_Flag;

  CHAR_UG_MAX File_Name;

  if (Output_File_Flag)
  {
    snprintf (File_Name, sizeof(File_Name), "%s.%s.log", Case_Name, Program_Name);

    if (Output_File_Flag > 0)
      ug_backup_file (File_Name);

    if (Output_File_Flag > 0)
      UG_Output_File = ug_fopen (File_Name, "w");
    else
      UG_Output_File = ug_fopen (File_Name, "a");

    if (UG_Output_File && ug_abs (Output_File_Flag) == 2)
      UG_Standard_Output_Flag = 0;
  }

  else if (UG_Output_File != NULL && strcmp (Program_Name, "close_output_file") == 0)
  {
    ug_fclose (UG_Output_File);

    UG_Output_File = NULL;
  }

  return;
}
