#include "UG_LIB.h"

INT_ ug_malloc_param
 (UG_Param_Struct ** UG_Param_Struct_Ptr)

{

/*
 * Malloc UG parameter structure arrays.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_malloc_param.c,v 1.44 2021/02/09 04:44:55 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  UG_Param_Struct *Struct_Ptr_Ptr;

  INT_ Index;

  INT_ Error_Flag = 0;

  INT_ Max_Char_Params = 100;
  INT_ Max_Double_Params = 100;
  INT_ Max_Int_Params = 100;

  ug_set_param_def (NULL);

  *UG_Param_Struct_Ptr = (UG_Param_Struct *)
                          ug_malloc (&Error_Flag, sizeof (UG_Param_Struct));

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100413 : unable to allocate space for parameter structure ***");
    return (100413);
  }

  Struct_Ptr_Ptr = *UG_Param_Struct_Ptr;

  Struct_Ptr_Ptr->Max_Char_Params = Max_Char_Params;
  Struct_Ptr_Ptr->Number_of_Char_Params = 0;

  Struct_Ptr_Ptr->Char_Param_Info = (CHAR_81 *)
                                     ug_malloc (&Error_Flag,
                                                Max_Char_Params
                                              * sizeof (CHAR_81));
  Struct_Ptr_Ptr->Char_Param_Doc = (char **)
                                     ug_malloc (&Error_Flag,
                                                Max_Char_Params
                                              * sizeof (char *));
  Struct_Ptr_Ptr->Char_Param_Name = (CHAR_25 *)
                                    ug_malloc (&Error_Flag,
                                               Max_Char_Params
                                             * sizeof (CHAR_25));
  Struct_Ptr_Ptr->Char_Param_Alt_Name = (CHAR_UG_MAX *)
                                    ug_malloc (&Error_Flag,
                                               Max_Char_Params
                                             * sizeof (CHAR_UG_MAX));
  Struct_Ptr_Ptr->Char_Param = (CHAR_UG_MAX *)
                               ug_malloc (&Error_Flag,
                                          Max_Char_Params
                                        * sizeof (CHAR_UG_MAX));
  Struct_Ptr_Ptr->Def_Char_Param = (CHAR_UG_MAX *)
                                   ug_malloc (&Error_Flag,
                                              Max_Char_Params
                                            * sizeof (CHAR_UG_MAX));
  Struct_Ptr_Ptr->Char_Param_Rank = (INT_1D *)
                                   ug_malloc (&Error_Flag,
                                              Max_Char_Params
                                            * sizeof (INT_1D));
  Struct_Ptr_Ptr->Char_Param_Type = (INT_1D *)
                                   ug_malloc (&Error_Flag,
                                              Max_Char_Params
                                            * sizeof (INT_1D));

  Struct_Ptr_Ptr->Max_Double_Params = Max_Double_Params;
  Struct_Ptr_Ptr->Number_of_Double_Params = 0;
  Struct_Ptr_Ptr->Number_of_Double_Param_Vector_Entries = 0;

  Struct_Ptr_Ptr->Double_Param_Info = (CHAR_81 *)
                                       ug_malloc (&Error_Flag,
                                                  Max_Double_Params
                                                * sizeof (CHAR_81));
  Struct_Ptr_Ptr->Double_Param_Doc = (char **)
                                       ug_malloc (&Error_Flag,
                                                  Max_Double_Params
                                                * sizeof (char *));
  Struct_Ptr_Ptr->Double_Param_Name = (CHAR_25 *)
                                      ug_malloc (&Error_Flag,
                                                 Max_Double_Params
                                               * sizeof (CHAR_25));
  Struct_Ptr_Ptr->Double_Param_Alt_Name = (CHAR_UG_MAX *)
                                    ug_malloc (&Error_Flag,
                                               Max_Double_Params
                                             * sizeof (CHAR_UG_MAX));
  Struct_Ptr_Ptr->Double_Param_Rank = (INT_1D *)
                                   ug_malloc (&Error_Flag,
                                              Max_Double_Params
                                            * sizeof (INT_1D));
  Struct_Ptr_Ptr->Double_Param_Vector_Entries = (INT_1D *)
                                                ug_malloc (&Error_Flag,
                                                           Max_Double_Params
                                                         * sizeof (INT_1D));
  Struct_Ptr_Ptr->Double_Param_Vector_Loc = (INT_1D *)
                                            ug_malloc (&Error_Flag,
                                                       Max_Double_Params
                                                     * sizeof (INT_1D));
  Struct_Ptr_Ptr->Double_Param = (DOUBLE_1D *)
                                 ug_malloc (&Error_Flag,
                                            Max_Double_Params
                                          * sizeof (DOUBLE_1D));
  Struct_Ptr_Ptr->Double_Param_Vector = NULL;
  Struct_Ptr_Ptr->Def_Double_Param = (DOUBLE_1D *)
                                     ug_malloc (&Error_Flag,
                                                 Max_Double_Params
                                              * sizeof (DOUBLE_1D));
  Struct_Ptr_Ptr->Inp_Double_Param = (DOUBLE_1D *)
                                     ug_malloc (&Error_Flag,
                                                 Max_Double_Params
                                              * sizeof (DOUBLE_1D));
  Struct_Ptr_Ptr->Max_Double_Param = (DOUBLE_1D *)
                                     ug_malloc (&Error_Flag,
                                                 Max_Double_Params
                                              * sizeof (DOUBLE_1D));
  Struct_Ptr_Ptr->Min_Double_Param = (DOUBLE_1D *)  
                                     ug_malloc (&Error_Flag,
                                                 Max_Double_Params
                                              * sizeof (DOUBLE_1D));

  Struct_Ptr_Ptr->Max_Int_Params = Max_Int_Params;
  Struct_Ptr_Ptr->Number_of_Int_Params = 0;
  Struct_Ptr_Ptr->Number_of_Int_Param_Vector_Entries = 0;

  Struct_Ptr_Ptr->Int_Param_Info = (CHAR_81 *)
                                    ug_malloc (&Error_Flag,
                                               Max_Int_Params
                                             * sizeof (CHAR_81));
  Struct_Ptr_Ptr->Int_Param_Doc = (char **)
                                    ug_malloc (&Error_Flag,
                                               Max_Int_Params
                                             * sizeof (char *));
  Struct_Ptr_Ptr->Int_Param_Name = (CHAR_25 *)
                                   ug_malloc (&Error_Flag,
                                              Max_Int_Params
                                            * sizeof (CHAR_25));
  Struct_Ptr_Ptr->Int_Param_Alt_Name = (CHAR_UG_MAX *)
                                    ug_malloc (&Error_Flag,
                                               Max_Int_Params
                                             * sizeof (CHAR_UG_MAX));
  Struct_Ptr_Ptr->Int_Param_Rank = (INT_1D *)
                                             ug_malloc (&Error_Flag,
                                                        Max_Int_Params 
                                                      * sizeof (INT_1D));
  Struct_Ptr_Ptr->Int_Param_Vector_Entries = (INT_1D *)
                                             ug_malloc (&Error_Flag,
                                                        Max_Int_Params 
                                                      * sizeof (INT_1D));
  Struct_Ptr_Ptr->Int_Param_Vector_Loc = (INT_1D *)
                                         ug_malloc (&Error_Flag,
                                                    Max_Int_Params 
                                                  * sizeof (INT_1D));
  Struct_Ptr_Ptr->Int_Param = (INT_1D *)
                              ug_malloc (&Error_Flag,
                                         Max_Int_Params
                                       * sizeof (INT_1D));
  Struct_Ptr_Ptr->Int_Param_Vector = NULL;
  Struct_Ptr_Ptr->Def_Int_Param = (INT_1D *)
                                  ug_malloc (&Error_Flag,
                                             Max_Int_Params
                                           * sizeof (INT_1D));
  Struct_Ptr_Ptr->Inp_Int_Param = (INT_1D *)
                                  ug_malloc (&Error_Flag,
                                             Max_Int_Params
                                           * sizeof (INT_1D));
  Struct_Ptr_Ptr->Max_Int_Param = (INT_1D *)
                                  ug_malloc (&Error_Flag,
                                             Max_Int_Params
                                           * sizeof (INT_1D));
  Struct_Ptr_Ptr->Min_Int_Param = (INT_1D *)
                                  ug_malloc (&Error_Flag,
                                             Max_Int_Params 
                                           * sizeof (INT_1D));

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100414 : unable to allocate space for parameter structure ***");
    return (100414);
  }

  for (Index = 0; Index < Max_Char_Params; ++Index)
  {
    strcpy (Struct_Ptr_Ptr->Char_Param_Name[Index], "");
    strcpy (Struct_Ptr_Ptr->Char_Param_Alt_Name[Index], "");

    Struct_Ptr_Ptr->Char_Param_Rank[Index] = 5;
    Struct_Ptr_Ptr->Char_Param_Type[Index] = 1;

    strcpy (Struct_Ptr_Ptr->Char_Param_Info[Index], "");

    Struct_Ptr_Ptr->Char_Param_Doc[Index] = NULL;

    strcpy (Struct_Ptr_Ptr->Char_Param[Index], "");
    strcpy (Struct_Ptr_Ptr->Def_Char_Param[Index], "");
  }

  for (Index = 0; Index < Max_Double_Params; ++Index)
  {
    strcpy (Struct_Ptr_Ptr->Double_Param_Name[Index], "");
    strcpy (Struct_Ptr_Ptr->Double_Param_Alt_Name[Index], "");

    Struct_Ptr_Ptr->Double_Param_Rank[Index] = 5;

    strcpy (Struct_Ptr_Ptr->Double_Param_Info[Index], "");

    Struct_Ptr_Ptr->Double_Param_Doc[Index] = NULL;

    Struct_Ptr_Ptr->Double_Param[Index] = 0.0;
    Struct_Ptr_Ptr->Def_Double_Param[Index] = 0.0;
    Struct_Ptr_Ptr->Max_Double_Param[Index] = 0.0;
    Struct_Ptr_Ptr->Min_Double_Param[Index] = 0.0;

    Struct_Ptr_Ptr->Double_Param_Vector_Entries[Index] = -1;
    Struct_Ptr_Ptr->Double_Param_Vector_Loc[Index] = 0;
  }

  for (Index = 0; Index < Max_Int_Params; ++Index)
  {
    strcpy (Struct_Ptr_Ptr->Int_Param_Name[Index], "");
    strcpy (Struct_Ptr_Ptr->Int_Param_Alt_Name[Index], "");

    Struct_Ptr_Ptr->Int_Param_Rank[Index] = 5;

    strcpy (Struct_Ptr_Ptr->Int_Param_Info[Index], "");

    Struct_Ptr_Ptr->Int_Param_Doc[Index] = NULL;

    Struct_Ptr_Ptr->Int_Param[Index] = 0;
    Struct_Ptr_Ptr->Def_Int_Param[Index] = 0;
    Struct_Ptr_Ptr->Max_Int_Param[Index] = 0;
    Struct_Ptr_Ptr->Min_Int_Param[Index] = 0;

    Struct_Ptr_Ptr->Int_Param_Vector_Entries[Index] = -1;
    Struct_Ptr_Ptr->Int_Param_Vector_Loc[Index] = 0;
  }

  return (0);

}
