#include "UG_LIB.h"

/*
 * Memory allocation routines.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_malloc.c,v 1.49 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum 
 */

static int Memory_Monitor = 0;

static CHAR_UG_MAX Text;

static LONG_LONG_int *Pointer_Location = NULL;
static LONG_LONG_int *Pointer_Memory = NULL;

static double TM = 0.0;
static double MB = 1000000.0;
static double KB = 1000.0;

static LONG_LONG_int Total_Memory = 0;
static LONG_LONG_int Max_Memory = 0;

static int Found = 0;
static int Inc_Number_of_Pointers = 100;
static int Max_Number_of_Pointers = 0;
static int Number_of_Pointers = 0;
static int Pointer_Index = 0;
static int Total_MB = 0;

void ug_memory_monitor
 (char *Flag)
 
{

/*
 * Turn memory monitor on or off.
 */

  if (strcmp (Flag, "on") == 0)
  {
    if (Memory_Monitor == 1) return;

    Memory_Monitor = 1;
  }

  else if (strcmp (Flag, "full_on") == 0)
  {
    if (Memory_Monitor == 2) return;

    Memory_Monitor = 2;
  }

  else
  {
    if (Memory_Monitor)
    {
      ug_message ("");
      ug_message ("UG       : Memory Monitor Summary");

      TM = (double) (Max_Memory) / MB;

      Total_MB = (int) NINT (TM);

      if (Total_MB >= 10)
        snprintf (Text, sizeof(Text), "UG       : Maximum Memory    =%10i MBytes", Total_MB);
      else
      {
        TM = (double) (Max_Memory) / KB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "UG       : Maximum Memory    =%10i KBytes", Total_MB);
        else
        {
          Total_MB = (int) (Max_Memory);

          snprintf (Text, sizeof(Text), "UG       : Maximum Memory    =%10i  Bytes", Total_MB);
        }
      }

      ug_message (Text);

      TM = (double) (Total_Memory) / MB;

      Total_MB = (int) NINT (TM);

      if (Total_MB >= 10)
        snprintf (Text, sizeof(Text), "UG       : Final Memory      =%10i MBytes", Total_MB);
      else
      {
        TM = (double) (Total_Memory) / KB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "UG       : Final Memory      =%10i KBytes", Total_MB);
        else
        {
          Total_MB = (int) (Total_Memory);

          snprintf (Text, sizeof(Text), "UG       : Final Memory      =%10i  Bytes", Total_MB);
        }
      }

      ug_message (Text);
      ug_message ("");
    }

    Memory_Monitor = 0;
  }

  Max_Number_of_Pointers = 0;

  Number_of_Pointers = 0;

  Total_Memory = 0;

  Max_Memory = 0;

  if (Pointer_Location)
    free (Pointer_Location);

  if (Pointer_Memory)
    free (Pointer_Memory);

  Pointer_Location = NULL;

  Pointer_Memory = NULL;

  return;

}

void ug_free
 (void * Pointer)

{

/*
 * Free array space previously allocated using ug_malloc or ug_realloc.
 */

  if (Pointer == NULL)
    return;

  free (Pointer);

  if (Memory_Monitor)
  {
    Found = 0;

    if (Number_of_Pointers > 0)
    {
      Pointer_Index = 0;

      do
      {
        if (Pointer_Location[Pointer_Index] == (LONG_LONG_int) Pointer) Found = 1;

        ++Pointer_Index;
      }
      while (Pointer_Index < Number_of_Pointers && ! Found);

      --Pointer_Index;
    }

    if (Found)
    {
      Total_Memory = Total_Memory - Pointer_Memory[Pointer_Index];

      Pointer_Location[Pointer_Index] = 0;

      Pointer_Memory[Pointer_Index] = 0;

      if (Memory_Monitor == 2)
      {
        TM = (double) (Total_Memory) / MB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "                                                            %12i MBytes", Total_MB);

        else
        {
          TM = (double) (Total_Memory) / KB;

          Total_MB = (int) NINT (TM);

          if (Total_MB >= 10)
            snprintf (Text, sizeof(Text), "                                                            %12i KBytes", Total_MB);

          else
          {
            Total_MB = (int) (Total_Memory);

            snprintf (Text, sizeof(Text), "                                                            %12i  Bytes", Total_MB);
          }
        }

        ug_message (Text);
      }
    }

    else if (! Found && Memory_Monitor == 2)
    {
      TM = (double) (Total_Memory) / MB;

      Total_MB = (int) NINT (TM);

      if (Total_MB >= 10)
        snprintf (Text, sizeof(Text), "                                        unknown memory free %12i MBytes", Total_MB);

      else
      {
        TM = (double) (Total_Memory) / KB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "                                        unknown memory free %12i KBytes", Total_MB);

        else
        {
          Total_MB = (int) (Total_Memory);

          snprintf (Text, sizeof(Text), "                                        unknown memory free %12i  Bytes", Total_MB);
        }
      }

      ug_message (Text);
    }
  }

  return;
}

void *ug_calloc
 (INT_ *Error_Flag,
  size_t Number_of_Elements,
  size_t Size_of_Each)

{
  
/*
 * Allocate array space and set each element to zero.
 */

  size_t Size;

  void *Pointer;

  Size = Size_of_Each * Number_of_Elements;

  Pointer = NULL;

  if (Size > 0)
    Pointer = malloc (Number_of_Elements*Size_of_Each);

  if (Size != 0 && Pointer == NULL)
    ++(*Error_Flag);
  else
    memset (Pointer, 0, Number_of_Elements*Size_of_Each);

  if (Memory_Monitor && Pointer)
  {
    Found = 0;

    if (Number_of_Pointers > 0)
    {
      Pointer_Index = 0;

      do
      {
        if (Pointer_Memory[Pointer_Index] == 0) Found = 1;

        ++Pointer_Index;
      }
      while (Pointer_Index < Number_of_Pointers && ! Found);

      --Pointer_Index;
    }

    if (! Found)
    {
      ++Number_of_Pointers;

      Pointer_Index = Number_of_Pointers - 1;

      if (Number_of_Pointers > Max_Number_of_Pointers)
      {
        Max_Number_of_Pointers = Max_Number_of_Pointers
                               + Inc_Number_of_Pointers;

        if (Pointer_Location == NULL)
          Pointer_Location = (LONG_LONG_int *) malloc (sizeof (LONG_LONG_int)
                                              * Max_Number_of_Pointers);
        else
          Pointer_Location = (LONG_LONG_int *) realloc (Pointer_Location,
                                                sizeof (LONG_LONG_int)
                                              * Max_Number_of_Pointers);

        if (Pointer_Memory == NULL)
          Pointer_Memory = (LONG_LONG_int *) malloc (sizeof (LONG_LONG_int)
                                            * Max_Number_of_Pointers);
        else
          Pointer_Memory = (LONG_LONG_int *) realloc (Pointer_Memory,
                                              sizeof (LONG_LONG_int)
                                            * Max_Number_of_Pointers);

        if (Pointer_Location == NULL || Pointer_Memory == NULL)
        {
          ug_memory_monitor ("off");

          ug_message ("                                                            MemoryMonitor ERROR");
        }
      }
    }

    Total_Memory = Total_Memory + (LONG_LONG_int) Size;

    Max_Memory = MAX (Max_Memory, Total_Memory);

    Pointer_Location[Pointer_Index] = (LONG_LONG_int) Pointer;

    Pointer_Memory[Pointer_Index] = (LONG_LONG_int) Size;

    if (Memory_Monitor == 2)
    {
      TM = (double) (Total_Memory) / MB;

      Total_MB = (int) NINT (TM);

      if (Total_MB >= 10)
        snprintf (Text, sizeof(Text), "                                                            %12i MBytes", Total_MB);

      else
      {
        TM = (double) (Total_Memory) / KB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "                                                            %12i KBytes", Total_MB);

        else
        {
          Total_MB = (int) (Total_Memory);

          snprintf (Text, sizeof(Text), "                                                            %12i  Bytes", Total_MB);
        }
      }

      ug_message (Text);
    }
  }

  return (Pointer);

}

void *ug_malloc
 (INT_ *Error_Flag,
  size_t Size)

{
  
/*
 * Allocate array space.
 */

  void *Pointer;

  Pointer = NULL;

  if (Size > 0)
    Pointer = malloc (Size);

  if (Size != 0 && Pointer == NULL)
    ++(*Error_Flag);

  if (Memory_Monitor && Pointer)
  {
    Found = 0;

    if (Number_of_Pointers > 0)
    {
      Pointer_Index = 0;

      do
      {
        if (Pointer_Memory[Pointer_Index] == 0) Found = 1;

        ++Pointer_Index;
      }
      while (Pointer_Index < Number_of_Pointers && ! Found);

      --Pointer_Index;
    }

    if (! Found)
    {
      ++Number_of_Pointers;

      Pointer_Index = Number_of_Pointers - 1;

      if (Number_of_Pointers > Max_Number_of_Pointers)
      {
        Max_Number_of_Pointers = Max_Number_of_Pointers
                               + Inc_Number_of_Pointers;

        if (Pointer_Location == NULL)
          Pointer_Location = (LONG_LONG_int *) malloc (sizeof (LONG_LONG_int)
                                              * Max_Number_of_Pointers);
        else
          Pointer_Location = (LONG_LONG_int *) realloc (Pointer_Location,
                                                sizeof (LONG_LONG_int)
                                              * Max_Number_of_Pointers);

        if (Pointer_Memory == NULL)
          Pointer_Memory = (LONG_LONG_int *) malloc (sizeof (LONG_LONG_int)
                                            * Max_Number_of_Pointers);
        else
          Pointer_Memory = (LONG_LONG_int *) realloc (Pointer_Memory,
                                              sizeof (LONG_LONG_int)
                                            * Max_Number_of_Pointers);

        if (Pointer_Location == NULL || Pointer_Memory == NULL)
        {
          ug_memory_monitor ("off");

          ug_message ("                                                            MemoryMonitor ERROR");
        }
      }
    }

    Total_Memory = Total_Memory + (LONG_LONG_int) Size;

    Max_Memory = MAX (Max_Memory, Total_Memory);

    Pointer_Location[Pointer_Index] = (LONG_LONG_int) Pointer;

    Pointer_Memory[Pointer_Index] = (LONG_LONG_int) Size;

    if (Memory_Monitor == 2)
    {
      TM = (double) (Total_Memory) / MB;

      Total_MB = (int) NINT (TM);

      if (Total_MB >= 10)
        snprintf (Text, sizeof(Text), "                                                            %12i MBytes", Total_MB);

      else
      {
        TM = (double) (Total_Memory) / KB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "                                                            %12i KBytes", Total_MB);

        else
        {
          Total_MB = (int) (Total_Memory);

          snprintf (Text, sizeof(Text), "                                                            %12i  Bytes", Total_MB);
        }
      }

      ug_message (Text);
    }
  }

  return (Pointer);

}

void *ug_realloc
 (INT_ * Error_Flag,
  void * Pointer,
  size_t Size)
  
{

/*
 * Reallocate array space previously allocated using ug_malloc or ug_realloc.
 */

  void *New_Pointer = NULL;

  if (Size > 0)
  {
    if (Pointer)
      New_Pointer = realloc (Pointer, Size);
    else
      New_Pointer = malloc (Size);
  }

  if (Size != 0 && New_Pointer == NULL)
  {
    ++(*Error_Flag);

    if (Pointer)
      New_Pointer = Pointer;
  }

  if (Memory_Monitor && New_Pointer)
  {
    if (Pointer)
    {
      Found = 0;

      if (Number_of_Pointers > 0)
      {
        Pointer_Index = 0;

        do
        {
          if (Pointer_Location[Pointer_Index] == (LONG_LONG_int) Pointer) Found = 1;

          ++Pointer_Index;
        }
        while (Pointer_Index < Number_of_Pointers && ! Found);

        --Pointer_Index;
      }

      if (Found)
      {
        Total_Memory = Total_Memory + (LONG_LONG_int) Size
                     - Pointer_Memory[Pointer_Index];

        Max_Memory = MAX (Max_Memory, Total_Memory);

        Pointer_Location[Pointer_Index] = (LONG_LONG_int) New_Pointer;

        Pointer_Memory[Pointer_Index] = (LONG_LONG_int) Size;

        if (Memory_Monitor == 2)
        {
          TM = (double) (Total_Memory) / MB;

          Total_MB = (int) NINT (TM);

          if (Total_MB >= 10)
            snprintf (Text, sizeof(Text), "                                                            %12i MBytes", Total_MB);

          else
          {
            TM = (double) (Total_Memory) / KB;

            Total_MB = (int) NINT (TM);

            if (Total_MB >= 10)
              snprintf (Text, sizeof(Text), "                                                            %12i KBytes", Total_MB);

            else
            {
              Total_MB = (int) (Total_Memory);

              snprintf (Text, sizeof(Text), "                                                            %12i  Bytes", Total_MB);
            }
          }

          ug_message (Text);
        }
      }

      else if (! Found && Memory_Monitor == 2)
      {
        TM = (double) (Total_Memory) / MB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "                                     unknown memory realloc %12i MBytes", Total_MB);

        else
        {
          TM = (double) (Total_Memory) / KB;

          Total_MB = (int) NINT (TM);

          if (Total_MB >= 10)
            snprintf (Text, sizeof(Text), "                                     unknown memory realloc %12i KBytes", Total_MB);

          else
          {
            Total_MB = (int) (Total_Memory);

            snprintf (Text, sizeof(Text), "                                     unknown memory realloc %12i  Bytes", Total_MB);
          }
        }

        ug_message (Text);
      }
    }
    else
    {
      Found = 0;

      if (Number_of_Pointers > 0)
      {
        Pointer_Index = 0;

        do
        {
          if (Pointer_Memory[Pointer_Index] == 0) Found = 1;

          ++Pointer_Index;
        }
        while (Pointer_Index < Number_of_Pointers && ! Found);

        --Pointer_Index;
      }

      if (! Found)
      {
        ++Number_of_Pointers;

        Pointer_Index = Number_of_Pointers - 1;

        if (Number_of_Pointers > Max_Number_of_Pointers)
        {
          Max_Number_of_Pointers = Max_Number_of_Pointers
                                 + Inc_Number_of_Pointers;

          if (Pointer_Location == NULL)
            Pointer_Location = (LONG_LONG_int *) malloc (sizeof (LONG_LONG_int)
                                                * Max_Number_of_Pointers);
          else
            Pointer_Location = (LONG_LONG_int *) realloc (Pointer_Location,
                                                  sizeof (LONG_LONG_int)
                                               * Max_Number_of_Pointers);

          if (Pointer_Memory == NULL)
            Pointer_Memory = (LONG_LONG_int *) malloc (sizeof (LONG_LONG_int)
                                              * Max_Number_of_Pointers);
          else
            Pointer_Memory = (LONG_LONG_int *) realloc (Pointer_Memory,
                                                sizeof (LONG_LONG_int)
                                              * Max_Number_of_Pointers);

          if (Pointer_Location == NULL || Pointer_Memory == NULL)
          {
            ug_memory_monitor ("off");

            ug_message ("                                                            MemoryMonitor ERROR");
          }
        }
      }

      Total_Memory = Total_Memory + (LONG_LONG_int) Size;

      Max_Memory = MAX (Max_Memory, Total_Memory);

      Pointer_Location[Pointer_Index] = (LONG_LONG_int) New_Pointer;

      Pointer_Memory[Pointer_Index] = (LONG_LONG_int) Size;

      if (Memory_Monitor == 2)
      {
        TM = (double) (Total_Memory) / MB;

        Total_MB = (int) NINT (TM);

        if (Total_MB >= 10)
          snprintf (Text, sizeof(Text), "                                                            %12i MBytes", Total_MB);

        else
        {
          TM = (double) (Total_Memory) / KB;

          Total_MB = (int) NINT (TM);

          if (Total_MB >= 10)
            snprintf (Text, sizeof(Text), "                                                            %12i KBytes", Total_MB);

          else
          {
            Total_MB = (int) (Total_Memory);

            snprintf (Text, sizeof(Text), "                                                            %12i  Bytes", Total_MB);
          }
        }

        ug_message (Text);
      }
    }
  }

  return (New_Pointer);

}
