#include "UG_LIB.h"

INT_ ug_ivivm
 (INT_ ne,
  INT_ *nivm,
  INT_1D * ivie,
  INT_1D ** ivivm)

{

/*
 * Set map of non-sequential values to sequential values.
 * 
 * UG LIB : Unstructured Griv - General Purpose Routine Library
 * $Id: ug_ivivm.c,v 1.10 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, Daviv L. Marcum
 */

  INT_ ie, ierr, iv, ivm, ivmax, ivmin, miv;

  ivmax = ivie[1];
  ivmin = ivie[1];

  for (ie = 2; ie <= ne; ++ie)
  {
    ivmax = MAX (ivmax, ivie[ie]);
    ivmin = MIN (ivmin, ivie[ie]);
  }

  ivm =0;

  for (iv = ivmin; iv <= ivmax; ++iv)
  {
    miv = 0;

    ie = 1;

    while (ie <= ne && ! miv)
    {
      if (iv == ivie[ie])
        miv = 1;

      ++ie;
    }

    if (miv == 1)
      ++ivm;
  }

  *nivm = ivm;

  ierr = 0;

  *ivivm = (INT_1D *) ug_malloc (&ierr, (*nivm+1) * sizeof (INT_1D));

  if (ierr > 0)
  {
    ug_error_message ("*** ERROR 100412 : unable to allocate space for sequential data ***");
    return (100412);
  }

  ivm =0;

  for (iv = ivmin; iv <= ivmax; ++iv)
  {
    miv = 0;

    ie = 1;

    while (ie <= ne && ! miv)
    {
      if (iv == ivie[ie])
        miv = 1;

      ++ie;
    }

    if (miv == 1)
    {
      ++ivm;

      (*ivivm)[ivm] = iv;
    }
  }

  return (0);

}
