#include "UG_LIB.h"

/* 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_initialize_param.c,v 1.72 2025/10/02 05:38:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

INT_ ug_initialize_param (INT_ code, UG_Param_Struct * Param_Struct_Ptr)
{
  // Set the name, flag, default value, minimum allowable value, maximum
  // allowable value, and description for all common input parameters.

  //    code=2 for AFLR2C
  //    code=3 for AFLR3 with ANBL3
  //    code=4 for AFLR4
  //    code=5 for BLOOM3
  //    code=44 for AFLR4 part of AFLR43
  //    code=43 for AFLR3 part of AFLR43
  //	code=-3 for AFLR3 using AFLR3t interface

  CHAR_41 Text;

  INT_ ierr = 0;

  if (code != 43) {

    ierr = ug_set_int_param_struct ("Help_Flag", "",
     "List documentation of input parameters.",
     "\
If Help_Flag=-1, then list a short overview of input documentation. ; \
If Help_Flag=0, then do not list input documentation. ; \
If Help_Flag=1, then list summary of input parameters. ; \
If Help_Flag=2, then list documentation of input parameters. ; \
If Help_Flag=3, then list summary of all input parameters \
including those that should not be changed. ; \
If Help_Flag=4, then list documentation of all input parameters \
including those that should not be changed. ; \
This is a program parameter. \
     ",
     -1, 0, 0, -1, 4, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_int_param_struct ("Help_UG_IO_Flag", "",
     "List documentation of file I/O parameters.",
     "\
If Help_UG_IO_Flag=0, then do not list file I/O documentation. ; \
If Help_UG_IO_Flag=1, then list summary of file I/O parameters. ; \
If Help_UG_IO_Flag=2, then list documentation of file I/O parameters. ; \
This is a program parameter. \
     ",
     -1, 0, 0, 0, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-build", "",
     "List program version build number.",
     "This is a program parameter.", "",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-ver", "",
     "List program version number.",
     "This is a program parameter.", "",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-version", "",
     "List program version information.",
     "This is a program parameter.", "",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-h", "",
     "List summary of input parameters.",
     "This is a program parameter.",
     "Help_Flag=1",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-h_all", "",
     "List summary of all input parameters.",
     "\
Including those that should not be changed. ; \
This is a program parameter. \
",
     "Help_Flag=3",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-help", "",
     "List documentation of input parameters.",
     "This is a program parameter.",
     "Help_Flag=2",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-help_all", "",
     "List documentation of all input parameters.",
     "\
Including those that should not be changed. ; \
This is a program parameter. \
",
     "Help_Flag=4",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-h_io", "",
     "List summary of file I/O parameters.",
     "This is a program parameter.",
     "Help_UG_IO_Flag=1",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-help_io", "",
     "List documentation of file I/O parameters.",
     "This is a program parameter.",
     "Help_UG_IO_Flag=2",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-File_Status_Monitor", "",
     "Turn on file status monitor.",
     "\
If the file status monitor is on, then an output message is generated \
each time a file is opened or modified. ; \
This is a program parameter.",
     "File_Status_Monitor_Flag=1",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-Memory_Monitor", "",
     "Turn on memory monitor.",
     "\
If the memory monitor is on and in summary output mode, then a summary message \
is generated at completion with the maximum memory allocated during execution \
and the final memory at completion (which should be 0). ; \
This is a program parameter.",
     "Memory_Monitor_Flag=1",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-Memory_Monitor2", "",
     "Turn on memory monitor.",
     "\
If the memory monitor is on and in full output mode, then an output message \
is generated each time memory is allocated, re-allocated, or freed. ; \
This is a program parameter.",
     "Memory_Monitor_Flag=2",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;
  }

  if (code == 2 || code == 3)
    ierr = ug_set_char_param_struct ("-convert", "",
     "Read input grid file and write output grid file.",
     "This is a program parameter.",
     "Program_Flag=0",
     2, 2, Param_Struct_Ptr);

  if (ierr) return ierr;

  if (code == 2)
    ierr = ug_set_char_param_struct ("-qstat", "",
     "Read input grid file and generate quality statistics.",
     "\
This option is only valid with an existing volume mesh. Only quality \
statistics are generated. ; \
This is a program parameter.",
     "Program_Flag=0 Output_Grid_File_Name=_null_",
     2, 2, Param_Struct_Ptr);

  if (code == 3)
    ierr = ug_set_char_param_struct ("-qstat", "",
     "Read input grid file and generate quality statistics.",
     "\
This option is only valid with an existing volume mesh. Only quality \
statistics are generated. ; \
This option is turned off if quality measure information is requested with \
option, -qchk. ; \
This is a program parameter.",
     "Program_Flag=0 mqchk=0 Output_Grid_File_Name=_null_",
     2, 2, Param_Struct_Ptr);

  if (ierr) return ierr;

  if (code == 3 || code == 5)
    ierr = ug_set_char_param_struct ("-qchk", "",
     "Read input grid file and generate element quality measure information.",
     "\
This option is only valid with an existing volume mesh. Only quality \
measure information is generated. Information generated includes element to \
neighbor element volume ratio. ; \
This option is turned off if quality statistics are requested with \
option, -qstat. ; \
This is a program parameter.",
     "Program_Flag=0 mqchk=2 Output_Grid_File_Name=_null_",
     2, 2, Param_Struct_Ptr);

  if (ierr) return ierr;

  if (code == 2 || code == 3 || code == -3 || code == 43) {

    ierr = ug_set_char_param_struct ("-no_back", "",
     "Do not read background grid and length-scale function files.",
     "\
Normally, if a background grid and length-scale function file are found then \
they are read \
and used to determine the sizing (see meval). A grid and length-scale \
function file with \
naming \"case_name.back.format_and_type\" are considered \
background grid files. ; \
This is a program parameter. \
     ",
     "BG_Flag=0",
     2, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_int_param_struct ("BG_Flag", "",
     "Background grid and length-scale function file flag.",
     "\
Normally, if a background grid and length-scale function file are found, then \
they are read \
and used to determine the sizing (see meval). A grid and length-scale \
function file with \
naming \"case_name.back.format_and_type\" are considered \
background grid files. ; \
If BG_Flag = 0, then do not read background grid and length-scale \
function files. ; \
If BG_Flag = 1, then read background grid and length-scale \
function files if found. ; \
This is a program parameter. \
     ",
     4, 0, 1, 0, 1, Param_Struct_Ptr);

    if (ierr) return ierr;
  }

  if (code == 3) {

    ierr = ug_set_char_param_struct ("-no_psdata", "",
     "Do not read PSDATA file.",
     "\
Do not read a PSDATA file even if it exists. ; \
This is a program parameter. \
     ",
     "PSDATA_File_Flag=0",
     2, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_int_param_struct ("PSDATA_File_Flag", "",
     "Control reading of PSDATA file.",
     "\
If PSDATA_File_Flag=0, then do not read a PSDATA file even if it exists. ; \
If PSDATA_File_Flag=1, then read a PSDATA file if it exists. ; \
This is a program parameter. \
     ",
     2, 0, 1, 0, 1, Param_Struct_Ptr);

    if (ierr) return ierr;
  }

  if (code == 2 || code == 3 || code == 4 || code == 5)
    ierr = ug_set_int_param_struct ("Program_Flag", "", 
     "Program flag.",
     "\
If Program_Flag = 0, then run program in post processing mode. ; \
If Program_Flag = 1, then run program in normal mode. ; \
This is a program parameter. \
     ",
     5, 0, 1, 0, 1, Param_Struct_Ptr);

  if (ierr) return ierr;

  if (code != 43) {

    ierr = ug_set_int_param_struct ("File_Status_Monitor_Flag", "", 
     "", "", 0, 0, 0, 0, 1, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_int_param_struct ("Memory_Monitor_Flag", "", 
     "", "", 0, 0, 0, 0, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_int_param_struct ("Message_Flag", "mmsg", 
     "Message flag.",
     "\
If Message_Flag = -1, then generate minimal one-line output messages. ; \
If Message_Flag =  0, then generate no output messages. ; \
If Message_Flag =  1, then generate normal output messages. ; \
If Message_Flag =  2, then generate all debug output messages. ; \
     ",
     4, 0, 1, -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_int_param_struct ("Output_File_Flag", "", 
     "Output file flag.",
     "\
If Output_File_Flag=0, then send all \
output to only standard output or \
standard error. ; \
If Output_File_Flag=1, then send \
informational output to both standard \
output (or standard error) and a file \
named case_name.program_name.out. ; \
If Output_File_Flag=2, then send \
informational output to a file named \
case_name.program_name.out only. ; \
If Output_File_Flag=-1, then send \
and append informational output to both standard \
output (or standard error) and a file \
named case_name.program_name.out. ; \
If Output_File_Flag=-2, then send \
and append informational output to a file named \
case_name.program_name.out only. ; \
Error messages will always go to both the file (if any) and standard error. ; \
This is a program parameter. \
     ",
     -1, 0, 0, -2, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    if (code != 44) {

      ierr = ug_set_char_param_struct ("Arg_File_Name", "-arg", 
       "Input argument file name.",
       "\
Specifies the full \
file name for the input argument file. This file is simply a list of \
command line arguments (one per line). A # anywhere in a line denotes that \
the line is a comment and will not be interpreted. \
An argument file named case_name.program_name.arg is generated \
each time the program runs successfully. Specifying the file allows \
for re-running a case with the same arguments. Additional input \
arguments can be added to the command line. If the file name is \
specified, then it must exist and a copy of it will be saved with a .bak \
suffix added if the program runs successfully. \
Note that from a command line this option can be specified as simply \
the name of the input parameter file if it is the only argument and if it \
has the standard .arg suffix. Otherwise it can only be specified, \
like other parameters, using the option flag followed by the name. ; \
This is a program parameter. \
       ",
       "",
       -1, 1, Param_Struct_Ptr);

      if (ierr) return ierr;
    }

    ierr = ug_set_char_param_struct ("-v", "", 
     "Use executable in specified directory.",
     "\
If a full directory path is specified, then it is assumed that it contains \
an executable of the same name as currently running or that it contains a bin \
directory with the executable. The order of search is ; \
; ^ \
/new_ver_dir/base_executable_name ; \
/new_ver_dir/base_executable_name.exe ; \
/new_ver_dir/bin/base_executable_name ; \
/new_ver_dir/bin/base_executable_name.exe ; \
; ^ \
Where new_ver_dir is the name specified after the -v argument and \
base_executable is the name of the currently running executable \
without a .exe extension. \
If a partial directory path is specified, then it is assumed that the directory \
is under the same tree as the directory for the currently running executable \
or the users home directory. If the executable is in the root directory, then \
only the home directory is checked. The order of search is ; \
; ^ \
/base_current_exe_dir/new_ver_dir/base_executable_name ; \
/base_current_exe_dir/new_ver_dir/base_executable_name.exe ; \
/base_current_exe_dir/new_ver_dir/bin/base_executable_name ; \
/base_current_exe_dir/new_ver_dir/bin/base_executable_name.exe ; \
HOME/new_ver_dir/base_executable_name ; \
HOME/new_ver_dir/base_executable_name.exe ; \
HOME/new_ver_dir/bin/base_executable_name ; \
HOME/new_ver_dir/bin/base_executable_name.exe ; \
; ^ \
Where new_ver_dir is the name specified after the -v argument, \
base_executable is the name of the currently running executable \
without a .exe extension, and \
base_current_exe_dir is the current base directory. The base directory is \
derived from the currently \
running executable path if it is base_current_exe_dir/executable_name \
or if it is base_current_exe_dir/bin/executable_name. ; \
In all cases the first path found to exist is used. On WINDOWS the \
directories searched are all assumed to reside on the same drive as \
the currently running executable. If it is not, then the new_ver_dir must be \
fully specified including the drive letter, making this option somewhat \
useless. ; \
This is a program parameter. \
",
     "",
     -1, 1, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-out", "-log", 
     "Generate an output file.",
     "\
Send all output to a file named case_name.program_name.log. ; \
Standard output will go to both the file and standard output. ; \
Standard error output will go to both the file and standard error. ; \
This is a program parameter. \
",
     "Output_File_Flag=1",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-outf", "-logf", 
     "Send output to a file only.",
     "\
Send all output to a file named case_name.program_name.log. ; \
Standard output will go to the file only. ; \
Standard error output will go to both the file and standard error. ; \
This is a program parameter. \
",
     "Output_File_Flag=2",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-out_a", "-log_a", 
     "Append an output file.",
     "\
Send all output to a file named case_name.program_name.log. ; \
Standard output will go to both the file and standard output. ; \
Standard error output will go to both the file and standard error. ; \
If the file does not exist, then it will be created. ; \
This is a program parameter. \
",
     "Output_File_Flag=-1",
    -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;

    ierr = ug_set_char_param_struct ("-outf_a", "-logf_a", 
     "Append output to a file only.",
     "\
Send all output to a file named case_name.program_name.log. ; \
Standard output will go to the file only. ; \
Standard error output will go to both the file and standard error. ; \
If the file does not exist, then it will be created. ; \
This is a program parameter. \
",
     "Output_File_Flag=-2",
     -1, 2, Param_Struct_Ptr);

    if (ierr) return ierr;
  }

  ierr = ug_set_char_param_struct ("TMP_File_Dir", "-tmp", 
   "Temporary file directory.",
   "\
If TMP_File_Dir is set, then all \
temporary files are created in directory \
TMP_File_Dir. This directory is removed \
at completion of the job. If program \
execution is abruptly terminated, then \
this directory and its contents may be \
left behind and not removed. ; \
This is a program parameter. \
   ",
   "_null_",
   -1, 1, Param_Struct_Ptr);

  if (ierr) return ierr;

  if (code == 2 || code == 3 || code == -3 || code == 43)
    ierr = ug_set_char_param_struct ("BG_Case_Name", "-ib -iback -bcase", 
     "Case name for background grid and function file names.",
     "\
Specifies the case name for the background grid and function files. \
If BG_Case_Name is not specified, then the case name from the input grid file \
is used. ; \
This is a program parameter. \
     ",
     "",
     1, 1, Param_Struct_Ptr);

  if (ierr) return ierr;

  // set I/O params

  if (code == 2 || code == 3 || code == 5)
    ierr = ug_set_char_param_struct ("Input_Grid_File_Name", "-i -igrid -case", 
     "Case name or input grid file name.",
     "\
Specifies either the case name or full file name for the input grid file. See \
the UG_IO description on file naming for more information. ; \
This is a program parameter. \
     ",
     "",
     -1, 1, Param_Struct_Ptr);

  else if (code == 4 || code == -3 || code == 43 || code == 44)
    ierr = ug_set_char_param_struct ("Input_File_Name", "-i -cad -igrid -case", 
     "Input CAD file case name or file name or input CAD file name.",
     "\
Specifies either the case name or full file name for the input CAD file. \
Alternatively, specifies either the case name or full file name for the input \
grid file. See the UG_IO description on file naming for more information. \
Note that if only a case name is specified, then an input CAD file is searched \
for first. If no suitable CAD file type is found, then an input grid file is \
searched for. ; \
This is a program parameter. \
     ",
     "",
     -1, 1, Param_Struct_Ptr);

  if (ierr) return ierr;

  if (code == 4 || code == 5 || code == -3 || code == 43)
    strcpy (Text, ".meshb");
  else if (code == 44)
    strcpy (Text, "_null_");
  else if (sizeof (INT_) == sizeof (int))
    strcpy (Text, ".b8.ugrid");
  else
    strcpy (Text, ".b8l.ugrid");

  ierr = ug_set_char_param_struct ("Output_Grid_File_Name", "-o -ogrid", 
   "Output grid file name or suffix.",
   "\
Specifies either the full file name or file name suffix for the output grid \
file. See the UG_IO description on file naming for more information. ; \
If Output_Grid_File=_null_, then do not write an output grid file. ; \
This is a program parameter. \
   ",
   Text,
   -1, 1, Param_Struct_Ptr);

  if (ierr) return ierr;
 
  if (code == 2 || code == 3 || code == -3 || code == 43) {

    ierr = ug_set_char_param_struct ("Input_Case_Name", "",
     "", "", "", 0, 1, Param_Struct_Ptr);

    if (ierr) return (ierr);
 
    ierr = ug_set_char_param_struct ("BG_Grid_File_Name", "",
     "", "", "", 0, 1, Param_Struct_Ptr);

    if (ierr) return (ierr);
 
    ierr = ug_set_char_param_struct ("BG_Func_File_Name", "",
     "", "", "", 0, 1, Param_Struct_Ptr);

    if (ierr) return (ierr);
 
    ierr = ug_set_char_param_struct ("Source_Data_File_Name", "",
     "", "", "", 0, 1, Param_Struct_Ptr);

    if (ierr) return (ierr);
  }

  ug_set_param_def (Param_Struct_Ptr);

  return 0;
}
