#include "UG_LIB.h"

INT_ ug_getline
 (char **Line,
  FILE *File_Stream)

{

/*
 * Read one line of a file stream and store the line in a string 
 * and allocate space for the string.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_getline.c,v 1.8 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  char *Pointer;
  char *Block = NULL;

  INT_ Block_Length, EOF_Flag, EOL_Flag, Error_Flag;
  INT_ n = 0;

  Block_Length = UG_MAX_CHAR_STRING_LENGTH;

  *Line = NULL;

  if (File_Stream == NULL)
  {
    ug_error_message ("*** ERROR 421 : File Stream is NULL ***");
    return (421);
  }

  do
  {
    n = n + Block_Length;

    Error_Flag = 0;

    *Line = (char *) ug_realloc (&Error_Flag, *Line, (n+1) * sizeof (char));

    if (Error_Flag)
    {
      ug_free (*Line);
      *Line = NULL;
      ug_error_message ("*** ERROR 100441 : unable to allocate space for string from one file line ***");
      return (100441);
    }

    Block = *Line + n - Block_Length;

    Pointer = fgets (Block, (int) (Block_Length+1), File_Stream);

    EOL_Flag = 0;

    if (Pointer)
    {
      Pointer = strchr (Block, '\n');

      if (Pointer)
      {
        EOL_Flag = 1;

        strcpy (Pointer, "");

        if (strchr (*Line, '#'))
        {
          EOL_Flag = 0;

          n = 0;

          ug_free (*Line);

          *Line = NULL;
        }
      }
    }

    EOF_Flag = feof (File_Stream);
  }
  while (EOF_Flag == 0 && EOL_Flag == 0);

  if (EOF_Flag)
  {
    ug_free (*Line);

    *Line = NULL;

    return (-1);
  }

  return (0);
}
