#include "UG_LIB.h"
INT_ ug_get_int_range_from_string
 (char Sub_String[],
  INT_ *Int_Param_Value_1,
  INT_ *Int_Param_Value_2);

INT_ ug_get_param_from_value
 (char Char_Param_Value[],
  char Value[],
  INT_ *Entries,
  INT_ *Int_Param_Value,
  INT_ *Param_Type_Flag,
  INT_1D **_Int_Param_Vector,
  double *Double_Param_Value,
  DOUBLE_1D **_Double_Param_Vector)

{

/*
 * Get a UG parameter from a given value sub-string.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_get_param_from_value.c,v 1.27 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  char *Sub_String_Ptr;
  char *String_Ptr;
  char *tmp_String_Ptr;

  CHAR_UG_MAX Sub_String;

  static INT_ Vector_Index = 0;

  INT_ Entry_Type, Error_Flag,
       Int_Param_Value_, Int_Param_Value_1, Int_Param_Value_2,
       Length, Max_Entries, Pass, Read_Flag;

  int int_value;

  double Double_Param_Value_;

  // set character parameter

  if (*Param_Type_Flag == CHAR_PARAM_TYPE_FLAG || *Param_Type_Flag == OPT_PARAM_TYPE_FLAG || *Param_Type_Flag == OPT_VALUE_PARAM_TYPE_FLAG)
    strcpy (Char_Param_Value, Value);

  // set double parameter

  else if (*Param_Type_Flag == DOUBLE_PARAM_TYPE_FLAG)
  {
    Read_Flag = sscanf (Value, "%lf", Double_Param_Value);

    if (Read_Flag != 1)
    {
      ug_error_message ("*** ERROR 410 : error processing input parameters ***");
      return (410);
    }
  }

  // set int parameter

  else if (*Param_Type_Flag == INT_PARAM_TYPE_FLAG)
  {
    Read_Flag = sscanf (Value, "%i", &int_value);

    *Int_Param_Value = (INT_) int_value;

    if (Read_Flag != 1)
    {
      ug_error_message ("*** ERROR 410 : error processing input parameters ***");
      return (410);
    }
  }

  // set double or int vector parameter of type-1 name entry1,entry2,...
  // or
  // set number of double or int vector parameters of type-2
  // name number_of_entries
  //      entry1
  //      entry2
  //      .
  //      .
  //      .

  else if (*Param_Type_Flag == DOUBLE_PARAM_VECTOR_TYPE_FLAG || *Param_Type_Flag == INT_PARAM_VECTOR_TYPE_FLAG)
  {
    Entry_Type = (strstr (Value, ",") || (*Param_Type_Flag == INT_PARAM_VECTOR_TYPE_FLAG && strstr (Value, "-"))) ? 1: 2;

    Error_Flag = 0;

    String_Ptr = (char *) ug_malloc (&Error_Flag, (strlen (Value) + 1) * sizeof (char));

    if (Error_Flag)
    {
      ug_free (String_Ptr);
      ug_error_message ("*** ERROR 100430 : unable to allocate space for string ***");
      return (100430);
    }

    Pass = 1;

    do
    {
      if (Entry_Type == 1)
      {
        strcpy (String_Ptr, Value);

        Vector_Index = 0;

        do
        {
          Length = (INT_) strcspn (String_Ptr, ",");

          if (Length)
          {
            strcpy (Sub_String, "");

            strncat (Sub_String, String_Ptr, Length);

            if (*Param_Type_Flag == DOUBLE_PARAM_VECTOR_TYPE_FLAG)
            {
              Read_Flag = sscanf (Sub_String, "%lg", &Double_Param_Value_);

              if (Read_Flag != 1)
              {
                ug_free (String_Ptr);
                ug_error_message ("*** ERROR 410 : error processing input parameters ***");
                return (410);
              }

              if (Pass == 2)
                (*_Double_Param_Vector)[Vector_Index] = Double_Param_Value_;

              ++Vector_Index;
            }
            else
            {
              Error_Flag = ug_get_int_range_from_string (Sub_String, &Int_Param_Value_1, &Int_Param_Value_2);

              if (Error_Flag)
              {
                ug_free (String_Ptr);
                return (Error_Flag);
              }

              for (Int_Param_Value_ = Int_Param_Value_1; Int_Param_Value_ <= Int_Param_Value_2; ++Int_Param_Value_)
              {
                if (Pass == 2)
                  (*_Int_Param_Vector)[Vector_Index] = Int_Param_Value_;

                ++Vector_Index;
              }
            }

            Sub_String_Ptr = strstr (String_Ptr, ",");

            if (Sub_String_Ptr)
            {
              if (strlen (Sub_String_Ptr) > 1)
              {
                Sub_String_Ptr = Sub_String_Ptr+1;

                Error_Flag = 0;

                tmp_String_Ptr = (char *) ug_malloc (&Error_Flag, (strlen (Sub_String_Ptr) + 1) * sizeof (char));

                if (Error_Flag)
                {
                  ug_free (String_Ptr);
                  ug_free (tmp_String_Ptr);
                  ug_error_message ("*** ERROR 100431 : unable to allocate space for temporary string ***");
                  return (100431);
                }

                strcpy (tmp_String_Ptr, Sub_String_Ptr);
                strcpy (String_Ptr, tmp_String_Ptr);

                ug_free (tmp_String_Ptr);

                tmp_String_Ptr = NULL;
              }
              else
                Sub_String_Ptr = NULL;
            }
          }
          else
            Sub_String_Ptr = NULL;
        }
        while (Sub_String_Ptr);

        *Entries = Vector_Index;

        Vector_Index = 0;
      }
      else
      {
        *Entries = 0;

        Read_Flag = sscanf (Value, "%i", &int_value);

        *Entries = (INT_) int_value;

        if (*Entries < 0 || Read_Flag != 1)
        {
          ug_free (String_Ptr);
          ug_error_message ("*** ERROR 410 : error processing input parameters ***");
          return (410);
        }
      }

      if (*Entries == 0)
      {
        ug_free (String_Ptr);
        return (-4);
      }

      if (Pass == 1)
      {
        Error_Flag = 0;

        if (*Param_Type_Flag == DOUBLE_PARAM_VECTOR_TYPE_FLAG)
          *_Double_Param_Vector = (DOUBLE_1D *) ug_malloc (&Error_Flag, (*Entries) * sizeof (DOUBLE_1D));
        else
          *_Int_Param_Vector = (INT_1D *) ug_malloc (&Error_Flag, (*Entries) * sizeof (INT_1D));

        if (Error_Flag > 0)
        {
          ug_free (String_Ptr);
          if (*Param_Type_Flag == DOUBLE_PARAM_VECTOR_TYPE_FLAG)
          {
            ug_free (*_Double_Param_Vector);
            *_Double_Param_Vector = NULL;
          }
          else
          {
            ug_free (*_Int_Param_Vector);
            *_Int_Param_Vector = NULL;
          }
          ug_error_message ("*** ERROR 100409 : unable to allocate space for vector parameter ***");
          return (100409);
        }

        if (Entry_Type == 2)
        {
          *Param_Type_Flag = -(*Param_Type_Flag);

          Vector_Index = 0;

          ++Pass;
        }
      }

      ++Pass;
    }
    while (*Entries && Pass <= 2);

    ug_free (String_Ptr);

    String_Ptr = NULL;
  }

  // continue setting double vector parameter of type-2
  // name number_of_entries
  //      entry1
  //      entry2
  //      .
  //      .
  //      .

  else if (*Param_Type_Flag == -DOUBLE_PARAM_VECTOR_TYPE_FLAG)
  {
    Read_Flag = sscanf (Value, "%lg", &Double_Param_Value_);

    if (Read_Flag != 1)
    {
      ug_free (*_Double_Param_Vector);

      *_Double_Param_Vector = NULL;

      *Param_Type_Flag = ug_abs (*Param_Type_Flag);

      ug_error_message ("*** ERROR 410 : error processing input parameters ***");
      return (410);
    }

    (*_Double_Param_Vector)[Vector_Index] = Double_Param_Value_;

    ++Vector_Index;

    if (Vector_Index == *Entries)
      *Param_Type_Flag = ug_abs (*Param_Type_Flag);
  }

  // continue setting int vector parameter of type
  // name number_of_entries
  //      entry1
  //      entry2
  //      .
  //      .
  //      .

  else if (*Param_Type_Flag == -INT_PARAM_VECTOR_TYPE_FLAG)
  {
    Error_Flag = ug_get_int_range_from_string (Value, &Int_Param_Value_1, &Int_Param_Value_2);

    if (Error_Flag)
    {
      ug_free (*_Int_Param_Vector);

      *_Int_Param_Vector = NULL;

      *Param_Type_Flag = ug_abs (*Param_Type_Flag);

      return (Error_Flag);
    }

    Max_Entries = Vector_Index + Int_Param_Value_2 - Int_Param_Value_1 + 1;

    if (Max_Entries > *Entries)
    {
      ug_free (*_Int_Param_Vector);

      *_Int_Param_Vector = NULL;

      *Param_Type_Flag = -(*Param_Type_Flag);

      ug_error_message ("*** ERROR 410 : error processing input parameters ***");
      return (410);
    }

    for (Int_Param_Value_ = Int_Param_Value_1; Int_Param_Value_ <= Int_Param_Value_2; ++Int_Param_Value_)
    {
      (*_Int_Param_Vector)[Vector_Index] = Int_Param_Value_;

      ++Vector_Index;
    }

    if (Vector_Index == *Entries)
      *Param_Type_Flag = ug_abs (*Param_Type_Flag);
  }
  
  // parameter type is unkown

  else
    return (-2);

  return (0);

}

INT_ ug_get_int_range_from_string
 (char Sub_String[],
  INT_ *Int_Param_Value_1,
  INT_ *Int_Param_Value_2)

{

  CHAR_UG_MAX Range_String;

  char *String_Ptr;

  INT_ Length, Read_Flag;

  int int_value;

  if (strstr (Sub_String, "-"))
  {
    Length = (INT_) strcspn (Sub_String, "-");

    String_Ptr = Sub_String;

    if (Length == 0)
      Length = 1 + (INT_) strcspn (String_Ptr+1, "-");

    strcpy (Range_String, "");

    strncat (Range_String, String_Ptr, Length);

    Read_Flag = sscanf (Range_String, "%i", &int_value);

    *Int_Param_Value_1 = (INT_) int_value;

    if (Read_Flag != 1)
    {
      ug_error_message ("*** ERROR 410 : error processing input parameters ***");
      return (410);
    }

    String_Ptr = strstr (String_Ptr+1, "-");

    if (String_Ptr)
    {
      ++String_Ptr;

      Read_Flag = sscanf (String_Ptr, "%i", &int_value);

      *Int_Param_Value_2 = (INT_) int_value;

      if (Read_Flag != 1)
      {
        ug_error_message ("*** ERROR 410 : error processing input parameters ***");
        return (410);
      }
    }
    else
      *Int_Param_Value_2 = *Int_Param_Value_1;
  }
  else
  {
    Read_Flag = sscanf (Sub_String, "%i", &int_value);

    *Int_Param_Value_1 = (INT_) int_value;

    if (Read_Flag != 1)
    {
      ug_error_message ("*** ERROR 410 : error processing input parameters ***");
      return (410);
    }

    *Int_Param_Value_2 = *Int_Param_Value_1;
  }

  return (0);

}
