#include "UG_LIB.h"

INT_ ug_get_items_from_list
 (const char *list,
  const char *sep,
  CHAR_UG_MAX **items,
  INT_ *n)

{

/*
 * Get vector of items in a list.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_get_items_from_list.c,v 1.15 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  char *str_ptr;

  CHAR_UG_MAX str, tmp_str;

  INT_ err, i, length, max_length, j;

  if (! strstr (list, sep))
    return (-1);

  for (j = 1; j <= 2; ++j)
  {
    strcpy (str, list);

    i = 0;

    max_length = 0;

    do
    {
      length = (INT_) strcspn (str, sep);

      if (length)
      {
        max_length = MAX (max_length, length);

        if (max_length >= UG_MAX_CHAR_STRING_LENGTH)
        {
          ug_error_message ("*** ERROR 414 : character string too long ***");
          return (414);
        }

        if (j == 2)
        {
          strcpy ((*items)[i], "");

          strncat ((*items)[i], str, (int) length);
        }

        ++i;
      }

      str_ptr = strstr (str, sep);

      if (str_ptr)
      {
        ++str_ptr;

        length = (INT_) strlen (str_ptr);

        if (length)
        {
          strcpy (tmp_str, str_ptr);
          strcpy (str, tmp_str);
        }
        else
          str_ptr = NULL;
      }
      else
        str_ptr = NULL;
    }
    while (str_ptr);

    *n = i;

    if (j == 1)
    {
      err = 0;

      *items = (CHAR_UG_MAX *) ug_malloc (&err, *n * sizeof (CHAR_UG_MAX));

      if (err)
      {
        ug_error_message ("*** ERROR 100408 : unable to allocate space for items in list ***");
        return (100408);
      }
    }
  }

  return (0);

}
