#include "UG_LIB.h"

void ug_get_data_size
 (char File_Name[],
  INT_ *n)

{

/*
 * Get data read size from a tmp file.
 *  
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_get_data_size.c,v 1.2 2015/06/19 06:13:49 marcum Exp $
 */

  CHAR_UG_MAX Text;

  FILE *Data_File = NULL;

  INT_ iread;

  if (ug_file_status_monitor_flag())
  {
    strcpy (Text, "ug_get_data_size         : reading 1 item of data from TMP file ");
    strncat (Text, File_Name, UG_MAX_CHAR_STRING_LENGTH-strlen(Text)-1);
    ug_message (Text);
  }

  ug_set_byte_order (ug_get_byte_order ());

  Data_File = ug_fopen (File_Name, "r_tmp");

  if (Data_File)
  {
    iread = ug_fread (n, sizeof (INT_), 1, Data_File);

    if (iread < 1)
      *n = 0;

    ug_close_dataf (File_Name);
  }
  else
    *n = 0;

  return;

}
