#include "UG_LIB.h"

void ug_free_param
 (UG_Param_Struct * UG_Param_Struct_Ptr)

{

/*
 * Free UG parameter structure arrays.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_free_param.c,v 1.16 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Index;

  if (UG_Param_Struct_Ptr)
  {
    for (Index = 0; Index < UG_Param_Struct_Ptr->Number_of_Char_Params; ++Index)
    {
      ug_free (UG_Param_Struct_Ptr->Char_Param_Doc[Index]);
    }
    for (Index = 0; Index < UG_Param_Struct_Ptr->Number_of_Double_Params; ++Index)
    {
      ug_free (UG_Param_Struct_Ptr->Double_Param_Doc[Index]);
    }
    for (Index = 0; Index < UG_Param_Struct_Ptr->Number_of_Int_Params; ++Index)
    {
      ug_free (UG_Param_Struct_Ptr->Int_Param_Doc[Index]);
    }

    ug_free (UG_Param_Struct_Ptr->Char_Param_Name);
    ug_free (UG_Param_Struct_Ptr->Char_Param_Alt_Name);
    ug_free (UG_Param_Struct_Ptr->Char_Param_Info);
    ug_free (UG_Param_Struct_Ptr->Char_Param_Doc);
    ug_free (UG_Param_Struct_Ptr->Char_Param);
    ug_free (UG_Param_Struct_Ptr->Def_Char_Param);
    ug_free (UG_Param_Struct_Ptr->Char_Param_Rank);
    ug_free (UG_Param_Struct_Ptr->Char_Param_Type);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Name);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Alt_Name);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Rank);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Info);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Doc);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Vector_Entries);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Vector_Loc);
    ug_free (UG_Param_Struct_Ptr->Double_Param);
    ug_free (UG_Param_Struct_Ptr->Double_Param_Vector);
    ug_free (UG_Param_Struct_Ptr->Def_Double_Param);
    ug_free (UG_Param_Struct_Ptr->Inp_Double_Param);
    ug_free (UG_Param_Struct_Ptr->Max_Double_Param);
    ug_free (UG_Param_Struct_Ptr->Min_Double_Param);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Name);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Alt_Name);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Rank);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Info);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Doc);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Vector_Entries);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Vector_Loc);
    ug_free (UG_Param_Struct_Ptr->Int_Param);
    ug_free (UG_Param_Struct_Ptr->Int_Param_Vector);
    ug_free (UG_Param_Struct_Ptr->Def_Int_Param);
    ug_free (UG_Param_Struct_Ptr->Inp_Int_Param);
    ug_free (UG_Param_Struct_Ptr->Max_Int_Param);
    ug_free (UG_Param_Struct_Ptr->Min_Int_Param);

    ug_free (UG_Param_Struct_Ptr);
  }

  return;

}
