#include "UG_LIB.h"

typedef struct _cpu_timer_struct cpu_timer_struct;

struct _cpu_timer_struct 
{
  CHAR_UG_MAX CPU_Timer_Label;
  double CPU_Time_Start;
  double CPU_Time_Total;
  double CPU_Time_Total_Overall;
};

void ug_cpu_timer (char *Task, char * Label)
{

/*
 * Time multiple calls of a labeled operation and output the total CPU time.
 *
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_cpu_timer.c,v 1.9 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;
  char Text_Label[21];

  static cpu_timer_struct *cpu_timer_struct_ptr = NULL;

  cpu_timer_struct *cpu_timer_struct_ptr_i;

  static INT_ n_cpu_timers = 0;
  static INT_ cpu_timer_err = 0;

  INT_ i = 0;
  INT_ found = 0;

  double CPU_Time_Total;

  if (cpu_timer_err)
    return;

  if (strcmp (Task, "create") == 0)
  {
    while (i < n_cpu_timers && found == 0)
    {
      cpu_timer_struct_ptr_i = &(cpu_timer_struct_ptr[i]);

      if (strcmp (cpu_timer_struct_ptr_i->CPU_Timer_Label, Label) == 0)
      {
        found = 1;

        cpu_timer_struct_ptr_i->CPU_Time_Start = ug_clock_gettime();
      }

      ++i;
    }

    if (found == 0)
    {
      cpu_timer_struct_ptr = (cpu_timer_struct *) ug_realloc (&cpu_timer_err,
                                                              cpu_timer_struct_ptr,
                                                              (n_cpu_timers+1) * (sizeof (cpu_timer_struct)));

      if (cpu_timer_err)
        return;

      cpu_timer_struct_ptr_i = &(cpu_timer_struct_ptr[n_cpu_timers]);

      strcpy (cpu_timer_struct_ptr_i->CPU_Timer_Label, Label);

      cpu_timer_struct_ptr_i->CPU_Time_Total = 0;
      cpu_timer_struct_ptr_i->CPU_Time_Total_Overall = 0;

      ++n_cpu_timers;
    }
  }

  if (strcmp (Task, "cleanup") == 0 || cpu_timer_err)
  {
    ug_free (cpu_timer_struct_ptr);

    n_cpu_timers = 0;

    cpu_timer_struct_ptr = NULL;
  }

  else if (strcmp (Task, "start") == 0)
  {
    while (i < n_cpu_timers && found == 0)
    {
      cpu_timer_struct_ptr_i = &(cpu_timer_struct_ptr[i]);

      if (strcmp (cpu_timer_struct_ptr_i->CPU_Timer_Label, Label) == 0)
      {
        found = 1;

        cpu_timer_struct_ptr_i->CPU_Time_Start = ug_clock_gettime();
      }

      ++i;
    }
  }

  else if (strcmp (Task, "stop") == 0)
  {
    while (i < n_cpu_timers && found == 0)
    {
      cpu_timer_struct_ptr_i = &(cpu_timer_struct_ptr[i]);

      if (strcmp (cpu_timer_struct_ptr_i->CPU_Timer_Label, Label) == 0)
      {
        found = 1;

        cpu_timer_struct_ptr_i->CPU_Time_Total = cpu_timer_struct_ptr_i->CPU_Time_Total + ug_clock_gettime() - cpu_timer_struct_ptr_i->CPU_Time_Start;
        cpu_timer_struct_ptr_i->CPU_Time_Total_Overall = cpu_timer_struct_ptr_i->CPU_Time_Total_Overall + ug_clock_gettime() - cpu_timer_struct_ptr_i->CPU_Time_Start;
      }

      ++i;
    }
  }

  else if (strcmp (Task, "output") == 0)
  {
    if (strcmp (Label, "ALL") == 0)
      found = 2;
    if (strcmp (Label, "OVERALL") == 0)
      found = 3;

    while (i < n_cpu_timers && found != 1)
    {
      cpu_timer_struct_ptr_i = &(cpu_timer_struct_ptr[i]);

      if (found == 0 && strcmp (Label, cpu_timer_struct_ptr_i->CPU_Timer_Label) == 0)
        found = 1;

      if (found)
      {
        strcpy (Text_Label, "");
        strncat (Text_Label, cpu_timer_struct_ptr_i->CPU_Timer_Label, 20); 

        if (found <= 2)
          CPU_Time_Total = cpu_timer_struct_ptr_i->CPU_Time_Total;
        else
          CPU_Time_Total = cpu_timer_struct_ptr_i->CPU_Time_Total_Overall;

        if (CPU_Time_Total < 60)
          snprintf (Text, sizeof(Text), "%-20s CPU Time=%10.3f   seconds", Text_Label, CPU_Time_Total);
        else if (CPU_Time_Total < 3600)
          snprintf (Text, sizeof(Text), "%-20s CPU Time=%10.3f   minutes", Text_Label, CPU_Time_Total/60.0);
        else
          snprintf (Text, sizeof(Text), "%-20s CPU Time=%10.3f     hours", Text_Label, CPU_Time_Total/3600.0);

        ug_message (Text);

        if (found)
          cpu_timer_struct_ptr_i->CPU_Time_Total = 0;

        if (found == 3)
          cpu_timer_struct_ptr_i->CPU_Time_Total_Overall = 0;
      }

      ++i;
    }
  }

  return;

}
