#include "UG_LIB.h"

void ug_cpu_message
 (char * Label)
{

/*
 * Write CPU time since last call to standard output.
 */

  double CPU_Time;

  ug_cpu_time (Label, 1, &CPU_Time);

  return;

}

void ug_cpu_time
 (char * Label,
  INT_ Flag,
  double * CPU_Time)
{

/*
 * Get CPU time since last call.
 * If Flag = 1 then also write CPU time since last call to standard output.
 *
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_cpu_message.c,v 1.25 2022/11/21 01:10:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text, Text_Label;

  static double initial_CPU_Time = -1;
  static double old_CPU_Time = -1;

  double new_CPU_Time;

  if (strcmp (Label, "reset") == 0)
  {
    old_CPU_Time = -1;

    return;
  }

  new_CPU_Time = ug_clock_gettime ();

  if (old_CPU_Time < 0)
    old_CPU_Time = new_CPU_Time;

  *CPU_Time = new_CPU_Time - old_CPU_Time;
  *CPU_Time = MAX (*CPU_Time, 0);

  old_CPU_Time = new_CPU_Time;

  if (strcmp (Label, "start_overall") == 0)
  {
    initial_CPU_Time = new_CPU_Time;

    old_CPU_Time = -1.0;

    return;
  }

  else if (strcmp (Label, "") == 0)
    return;

  else if (strcmp (Label, "end_overall") == 0)
  {
    *CPU_Time = new_CPU_Time - initial_CPU_Time;

    if (Flag)
      strcpy (Text_Label, "OVERALL  :");

    initial_CPU_Time = -1.0;

    old_CPU_Time = -1.0;
  }
  else
    strcpy (Text_Label, Label);

  if (Flag)
  {
    if (*CPU_Time < 60)
      snprintf (Text, sizeof(Text), "%s CPU Time          =%10.3f   seconds", Text_Label, *CPU_Time);
    else if (*CPU_Time < 3600)
      snprintf (Text, sizeof(Text), "%s CPU Time          =%10.3f   minutes", Text_Label, *CPU_Time/60.0);
    else
      snprintf (Text, sizeof(Text), "%s CPU Time          =%10.3f     hours", Text_Label, *CPU_Time/3600.0);

    ug_message (Text);
  }

  return;

}
