#include "UG_LIB.h"

INT_ ug_copy_argv (char **argv, char ***new_argv)
{
  int arg, argc, ierr;

  for (argc = 0; argv[argc] != NULL; argc++);
 
  ierr = 0;

  *new_argv = (char **) ug_malloc ((INT_ *) &ierr, (argc+1) * sizeof (char *));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100425 : unable to reallocate space for argument vector copy ***");
    return (100425);
  }

  for (arg = 0; arg < argc; ++arg)
  {
    (*new_argv)[arg] = (char *) ug_malloc ((INT_ *) &ierr, (strlen (argv[arg]) + 1) * sizeof (char));

    if (ierr)
    {
      (*new_argv)[arg] = NULL;
      ug_error_message ("*** ERROR 100426 : unable to allocate space for argument copy ***");
      return (100426);
    }

    strcpy ((*new_argv)[arg], argv[arg]);
  }

  (*new_argv)[arg] = NULL;

  return (0);
}
