#include "UG_LIB.h"

INT_ ug_compress_file
 (INT_ bg,
  char ext[],
  char path[])

{

/*
 * Compress file.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_compress_file.c,v 1.22 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX command;

  INT_ err = 0;

  strcpy (command, "");

#ifdef UG_SHELL_COMMAND_BZIP
  if (strstr (ext, UG_SHELL_COMMAND_BZIP_EXT)) strcpy (command, UG_SHELL_COMMAND_BZIP);
#endif 
#ifdef UG_SHELL_COMMAND_GZIP
  if (strstr (ext, UG_SHELL_COMMAND_GZIP_EXT)) strcpy (command, UG_SHELL_COMMAND_GZIP);
#endif 
#ifdef UG_SHELL_COMMAND_COMPRESS
  if (strstr (ext, UG_SHELL_COMMAND_COMPRESS_EXT)) strcpy (command, UG_SHELL_COMMAND_COMPRESS);
#endif 

  if (strcmp (command, ""))
  {
    strcat (command, " ");
    strcat (command, path);

    if (bg)
      strcat (command, UG_SHELL_COMMAND_BG);

    err = ug_system (command);
  }

  return (err);

}

INT_ ug_uncompress_file
 (char path[])

{

/*
 * Uncompress file.
 */

  CHAR_UG_MAX command;

  INT_ err = 0;

  strcpy (command, "");
#ifdef UG_SHELL_COMMAND_BUNZIP
  if (strstr (path, UG_SHELL_COMMAND_BZIP_EXT)) strcpy (command, UG_SHELL_COMMAND_BUNZIP);
#endif 
#ifdef UG_SHELL_COMMAND_GUNZIP
  if (strstr (path, UG_SHELL_COMMAND_GZIP_EXT)) strcpy (command, UG_SHELL_COMMAND_GUNZIP);
#endif 
#ifdef UG_SHELL_COMMAND_UNCOMPRESS
  if (strstr (path, UG_SHELL_COMMAND_COMPRESS_EXT)) strcpy (command, UG_SHELL_COMMAND_UNCOMPRESS);
#endif 

  if (strcmp (command, ""))
  {
    strcat (command, " ");
    strcat (command, path);

    err = ug_system (command);
  }

  return (err);

}

INT_ ug_uncompress_file2
 (char path[],
  char ext[])

{

/*
 * Set compression ext (if any) and uncompress file.
 */

  FILE * Data_File;

  CHAR_UG_MAX new_path;

  INT_ err = 0;
  INT_ i = 0;
  INT_ found = 0;

  while (i < 4 && err == 0 && found == 0) {
    if (i == 0)
      strcpy (ext, "");
    if (i == 1)
#ifdef UG_SHELL_COMMAND_GUNZIP
      strcpy (ext, UG_SHELL_COMMAND_GZIP_EXT);
#else
      i++;
#endif 
    if (i == 2)
#ifdef UG_SHELL_COMMAND_BUNZIP
      strcpy (ext, UG_SHELL_COMMAND_BZIP_EXT);
#else
      i++;
#endif 
    if (i == 3)
#ifdef UG_SHELL_COMMAND_UNCOMPRESS
      strcpy (ext, UG_SHELL_COMMAND_COMPRESS_EXT);
#else
      i++;
#endif 

    if (i < 4) {
      strcpy (new_path, path);
      strcat (new_path, ext);

      Data_File = ug_fopen (new_path, "r");

      if (Data_File) {
        ug_fclose (Data_File);
        Data_File = NULL;
        err = ug_uncompress_file (new_path);
        if (err == 0) found = 1;
      }
    }

    i++;
  }

  if (err)
    strcpy (ext, "");

  return err;

}
