#include "UG_LIB.h"

INT_ ug_check_file (const char *path, INT_ m)
{

/*
 * Check if file exists.
 * If m=0 then check only once.
 * If m=1 then repeat nrepeat_ times.
 * If m>1 then repeat "m" times.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_check_file.c,v 1.20 2023/06/23 19:00:19 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  static INT_ nrepeat_ = 1000;

  ug_stat_struct stat_struct;

  INT_ i, n;
  INT_ err = 0;

  n = (m == 1) ? nrepeat_: (m > 1) ? m: 0;

  if (err) return (-1);

  i = 0;

  do
  {
    err = ug_stat (path, &stat_struct);

    ++i;
  }
  while (i < n && err < 0);

  if (err < 0) return (-1);

  return (0);

}

INT_ ug_check_file_isdir (const char *path)
{ 
  ug_stat_struct stat_struct;
  CHAR_UG_MAX dpath;

  INT_ i, err;

  strcpy (dpath, path);

  err = ug_stat (dpath, &stat_struct);

  i = (err == 0 && S_ISDIR (stat_struct.st_mode)) ? 0: -1;

  return (i);
}

INT_ ug_check_file_isreg (const char *path)
{ 
  ug_stat_struct stat_struct;
  CHAR_UG_MAX dpath;

  INT_ i, err;

  strcpy (dpath, path);

  err = ug_stat (dpath, &stat_struct);

  i = (err == 0 && S_ISREG (stat_struct.st_mode)) ? 0: -1;

  return (i);
}

