#include "UG_LIB.h"

double ug_avg_double
 (INT_ Start_Index,
  INT_ End_Index,
  DOUBLE_1D * Data)

{

/*
 * Get average value in a DOUBLE array
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_avg_double.c,v 1.4 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Index;

  double Avg_Value;

  Avg_Value = Data[End_Index];

  for (Index = Start_Index; Index < End_Index; ++Index)
  {
    Avg_Value = Avg_Value + Data[Index];
  }

  Avg_Value = Avg_Value / ((double) (End_Index - Start_Index + 1));

  return (Avg_Value);

}
