#include "mesh_ug_io.h"
#include "libmeshb7.h"

INT_ mesh_ug_io_write_grid (char File_Name[],
                            INT_ Write_Task_Flag,
                            INT_ Number_of_Nodes,
                            INT_ Number_of_Bnd_Edges,
                            INT_ Number_of_Surf_Quads,
                            INT_ Number_of_Surf_Trias,
                            INT_ Number_of_Vol_Hexs,
                            INT_ Number_of_Vol_Pents_5,
                            INT_ Number_of_Vol_Pents_6,
                            INT_ Number_of_Vol_Tets,
                            INT_1D * Bnd_Edge_ID_Flag,
                            INT_2D * Bnd_Edge_Connectivity,
                            INT_1D * Surf_ID_Flag,
                            INT_4D * Surf_Quad_Connectivity,
                            INT_3D * Surf_Tria_Connectivity,
                            INT_8D * Vol_Hex_Connectivity,
                            INT_1D * Vol_ID_Flag,
                            INT_5D * Vol_Pent_5_Connectivity,
                            INT_6D * Vol_Pent_6_Connectivity,
                            INT_4D * Vol_Tet_Connectivity,
                            DOUBLE_3D * Coordinates)
{

/*
 * Write grid data to a MESH volume or surface grid file.
 *
 * $Id: mesh_ug_io_write_grid.c,v 1.5 2025/09/08 11:24:05 marcum Exp $
 */

  static LONG_LONG_int Grid_File_Index = 0;
  static INT_ Previous_Tasks = 0;
  static INT_ Total_Number_of_Nodes = 0;
  static INT_ Total_Number_of_Vol_Hexs = 0;
  static INT_ Total_Number_of_Vol_Pents_5 = 0;
  static INT_ Total_Number_of_Vol_Pents_6 = 0;
  static INT_ Total_Number_of_Vol_Tets = 0;

  INT_ Index;

  INT_ FilVer, ID;
  INT_ Dim = 3;

  double Size;
  double SizeLimit = 1.95;

  if (Grid_File_Index <= 0)
    Previous_Tasks = 0;

  if (Write_Task_Flag == 1 || Write_Task_Flag == -1)
  {
    Size = ((double) ((sizeof (DOUBLE_3D) + sizeof (INT_)) * Number_of_Nodes
                    + (sizeof (INT_2D) + sizeof (INT_)) * Number_of_Bnd_Edges
                    + (sizeof (INT_3D) + sizeof (INT_)) * Number_of_Surf_Trias
                    + (sizeof (INT_4D) + sizeof (INT_)) * Number_of_Surf_Quads
                    + (sizeof (INT_4D) + sizeof (INT_)) * Number_of_Vol_Tets
                    + (sizeof (INT_5D) + sizeof (INT_)) * Number_of_Vol_Pents_5
                    + (sizeof (INT_6D) + sizeof (INT_)) * Number_of_Vol_Pents_6
                    + (sizeof (INT_8D) + sizeof (INT_)) * Number_of_Vol_Hexs))
         / ((double) (1024 * 1024 * 1024));

    FilVer = (sizeof (INT_) == 8) ? 4: 
             (Size > SizeLimit) ? 3: 2;

    Grid_File_Index = GmfOpenMesh(File_Name, GmfWrite, FilVer, Dim);

    Total_Number_of_Nodes = Number_of_Nodes;
    Total_Number_of_Vol_Hexs = Number_of_Vol_Hexs;
    Total_Number_of_Vol_Pents_5 = Number_of_Vol_Pents_5;
    Total_Number_of_Vol_Pents_6 = Number_of_Vol_Pents_6;
    Total_Number_of_Vol_Tets = Number_of_Vol_Tets;

    Previous_Tasks = 1;
  }

  if (Grid_File_Index <= 0)
  {
    ug_error_message ("*** ERROR : error opening MESH grid file ***");
    return (1);
  }

  if (Write_Task_Flag == 1 || Write_Task_Flag == -2)
  {
    if (Write_Task_Flag == 1 || Previous_Tasks == 1)
      GmfSetKwd(Grid_File_Index,GmfVertices,Total_Number_of_Nodes);

    for (Index = 1; Index <= Number_of_Nodes; ++Index)
    {
      GmfSetLin(Grid_File_Index, GmfVertices,
                Coordinates[Index][0],
                Coordinates[Index][1],
                Coordinates[Index][2], 0);
    }

    Previous_Tasks = 2;
  }

  if (Write_Task_Flag == 1 || Write_Task_Flag == -3)
  {
    if (Number_of_Bnd_Edges > 0)
    {
      GmfSetKwd(Grid_File_Index,GmfEdges,Number_of_Bnd_Edges);

      for (Index = 1; Index <= Number_of_Bnd_Edges; ++Index)
      {
        ID = (Bnd_Edge_ID_Flag) ? Bnd_Edge_ID_Flag[Index]: 1;

        GmfSetLin(Grid_File_Index, GmfEdges,
                  Bnd_Edge_Connectivity[Index][0],
                  Bnd_Edge_Connectivity[Index][1],
                  ID);
      }
    }

    if (Number_of_Surf_Trias > 0)
    {
      GmfSetKwd(Grid_File_Index,GmfTriangles,Number_of_Surf_Trias);

      for (Index = 1; Index <= Number_of_Surf_Trias; ++Index)
      {
        GmfSetLin(Grid_File_Index, GmfTriangles,
                  Surf_Tria_Connectivity[Index][0],
                  Surf_Tria_Connectivity[Index][1],
                  Surf_Tria_Connectivity[Index][2],
                  Surf_ID_Flag[Index]);
      }
    }

    if (Number_of_Surf_Quads > 0)
    {
      GmfSetKwd(Grid_File_Index,GmfQuadrilaterals,Number_of_Surf_Quads);

      for (Index = 1; Index <= Number_of_Surf_Quads; ++Index)
      {
        GmfSetLin(Grid_File_Index, GmfQuadrilaterals,
                  Surf_Quad_Connectivity[Index][0],
                  Surf_Quad_Connectivity[Index][1],
                  Surf_Quad_Connectivity[Index][2],
                  Surf_Quad_Connectivity[Index][3],
                  Surf_ID_Flag[Number_of_Surf_Trias+Index]);
      }
    }

    Previous_Tasks = 3;
  }

  if (Write_Task_Flag == 1 || Write_Task_Flag == -4)
  {
    if (Number_of_Vol_Tets > 0)
    {
      if (Write_Task_Flag == 1 || Previous_Tasks <= 3)
        GmfSetKwd(Grid_File_Index, GmfTetrahedra,Total_Number_of_Vol_Tets);

      for (Index = 1; Index <= Number_of_Vol_Tets; ++Index)
      {
        ID = (Vol_ID_Flag) ? Vol_ID_Flag[Index]: 1;

        GmfSetLin(Grid_File_Index, GmfTetrahedra,
                  Vol_Tet_Connectivity[Index][0],
                  Vol_Tet_Connectivity[Index][1],
                  Vol_Tet_Connectivity[Index][2],
                  Vol_Tet_Connectivity[Index][3], ID);
      }
    }

    Previous_Tasks = 4;
  }

  if (Write_Task_Flag == 1 || Write_Task_Flag == -5)
  {
    if (Number_of_Vol_Pents_5 > 0)
    {
      if (Write_Task_Flag == 1 || Previous_Tasks <= 4)
        GmfSetKwd(Grid_File_Index,GmfPyramids,Total_Number_of_Vol_Pents_5);

      for (Index = 1; Index <= Number_of_Vol_Pents_5; ++Index)
      {
        if (Vol_ID_Flag) {
          if (Write_Task_Flag == 1)
            ID = Vol_ID_Flag[Total_Number_of_Vol_Tets+Index];
          else
            ID = Vol_ID_Flag[Index];
        }
        else
          ID = 2;

        GmfSetLin(Grid_File_Index,  GmfPyramids,
                  Vol_Pent_5_Connectivity[Index][0],
                  Vol_Pent_5_Connectivity[Index][3],
                  Vol_Pent_5_Connectivity[Index][4],
                  Vol_Pent_5_Connectivity[Index][1],
                  Vol_Pent_5_Connectivity[Index][2], ID);
      }
    }

    Previous_Tasks = 5;
  }

  if (Write_Task_Flag == 1 || Write_Task_Flag == -6)
  {
    if (Number_of_Vol_Pents_6 > 0)
    {
      if (Write_Task_Flag == 1 || Previous_Tasks <= 5)
        GmfSetKwd(Grid_File_Index,GmfPrisms,Total_Number_of_Vol_Pents_6);

      for (Index = 1; Index <= Number_of_Vol_Pents_6; ++Index)
      {
        if (Vol_ID_Flag) {
          if (Write_Task_Flag == 1)
            ID = Vol_ID_Flag[Total_Number_of_Vol_Tets+Total_Number_of_Vol_Pents_5+Index];
          else
            ID = Vol_ID_Flag[Index];
        }
        else
          ID = 3;

        GmfSetLin(Grid_File_Index,  GmfPrisms,
                  Vol_Pent_6_Connectivity[Index][0],
                  Vol_Pent_6_Connectivity[Index][1],
                  Vol_Pent_6_Connectivity[Index][2],
                  Vol_Pent_6_Connectivity[Index][3],
                  Vol_Pent_6_Connectivity[Index][4],
                  Vol_Pent_6_Connectivity[Index][5], ID);
      }
    }

    Previous_Tasks = 6;
  }

  if (Write_Task_Flag == 1 || Write_Task_Flag == -7)
  {
    if (Number_of_Vol_Hexs > 0)
    {
      if (Write_Task_Flag == 1 || Previous_Tasks <= 6)
        GmfSetKwd(Grid_File_Index,GmfHexahedra,Total_Number_of_Vol_Hexs);

      for (Index = 1; Index <= Number_of_Vol_Hexs; ++Index)
      {
        if (Vol_ID_Flag) {
          if (Write_Task_Flag == 1)
            ID = Vol_ID_Flag[Total_Number_of_Vol_Tets+Total_Number_of_Vol_Pents_5+Total_Number_of_Vol_Pents_6+Index];
          else
            ID = Vol_ID_Flag[Index];
        }
        else
          ID = 4;

        GmfSetLin(Grid_File_Index,  GmfHexahedra,
                  Vol_Hex_Connectivity[Index][0],
                  Vol_Hex_Connectivity[Index][1],
                  Vol_Hex_Connectivity[Index][2],
                  Vol_Hex_Connectivity[Index][3],
                  Vol_Hex_Connectivity[Index][4],
                  Vol_Hex_Connectivity[Index][5],
                  Vol_Hex_Connectivity[Index][6],
                  Vol_Hex_Connectivity[Index][7], ID);
      }
    }

    Previous_Tasks = 7;
  }

  if (Write_Task_Flag == 1 || Write_Task_Flag == -8)
    Previous_Tasks = 8;

  if (Write_Task_Flag == 1 || Write_Task_Flag == -9)
    Previous_Tasks = 9;

  if (Write_Task_Flag == 1 || Write_Task_Flag == -10)
  {
    GmfCloseMesh(Grid_File_Index);

    Grid_File_Index = 0;
    Previous_Tasks = 0;
    Total_Number_of_Nodes = 0;
    Total_Number_of_Vol_Hexs = 0;
    Total_Number_of_Vol_Pents_5 = 0;
    Total_Number_of_Vol_Pents_6 = 0;
    Total_Number_of_Vol_Tets = 0;
  }

  return (0);

}
