#include "mesh_ug_io.h"
#include "libmeshb7.h"

INT_ mesh_ug_io_write_2d_grid
 (char File_Name[],
  INT_ Number_of_Nodes,
  INT_ Number_of_Bnd_Edges,
  INT_ Number_of_Quads,
  INT_ Number_of_Trias,
  INT_1D * ID_Flag,
  INT_2D * Bnd_Edge_Connectivity,
  INT_1D * Face_ID_Flag,
  INT_4D * Quad_Connectivity,
  INT_3D * Tria_Connectivity,
  DOUBLE_2D * Coordinates)

{

/*
 * Write grid data to a 2D MESH volume or surface grid file.
 *
 * $Id: mesh_ug_io_write_2d_grid.c,v 1.3 2025/09/08 11:21:24 marcum Exp $
 */

  INT_ vID=1;
  int FilVer, IntType;
  int Dim = 2;
  LONG_LONG_int Grid_File_Index;

  double Size;
  double SizeLimit = 1.95;

  // Set your internal table integer size
  if(sizeof(INT_) == sizeof(LONG_int))
    IntType = GmfInt;
  else if(sizeof(INT_) == sizeof(LONG_LONG_int))
    IntType = GmfLong;
  else
  {
    ug_error_message ("*** ERROR : unsupported integer size by MESH grid reader ***");
    return (1);
  }

  Size = ((double) ((sizeof (DOUBLE_2D) + sizeof (INT_)) * Number_of_Nodes
                  + (sizeof (INT_2D) + sizeof (INT_)) * Number_of_Bnd_Edges
                  + (sizeof (INT_3D) + sizeof (INT_)) * Number_of_Trias
                  + (sizeof (INT_4D) + sizeof (INT_)) * Number_of_Quads))
       / ((double) (1024 * 1024 * 1024));

  FilVer = (sizeof (INT_) == 8) ? 4: 
           (Size > SizeLimit) ? 3: 2;

  Grid_File_Index = GmfOpenMesh(File_Name, GmfWrite, FilVer, Dim);

  if ( Grid_File_Index <= 0 ) {
    ug_error_message ("*** ERROR : error opening MESH grid file ***");
    return (1);
  }

  GmfSetKwd(Grid_File_Index,GmfVertices,Number_of_Nodes);
  GmfSetBlock(Grid_File_Index, GmfVertices, 1, Number_of_Nodes, 0, NULL, NULL,
              GmfDouble, &Coordinates[1][0], &Coordinates[Number_of_Nodes][0],
              GmfDouble, &Coordinates[1][1], &Coordinates[Number_of_Nodes][1],
              IntType,   &vID,               &vID);

  if (Number_of_Bnd_Edges > 0)
  {
    GmfSetKwd(Grid_File_Index,GmfEdges,Number_of_Bnd_Edges);
    GmfSetBlock(Grid_File_Index, GmfEdges, 1, Number_of_Bnd_Edges, 0, NULL, NULL,
                IntType, &Bnd_Edge_Connectivity[1][0], &Bnd_Edge_Connectivity[Number_of_Bnd_Edges][0],
                IntType, &Bnd_Edge_Connectivity[1][1], &Bnd_Edge_Connectivity[Number_of_Bnd_Edges][1],
                IntType, ID_Flag ? &ID_Flag[1] : &vID, ID_Flag ? &ID_Flag[Number_of_Bnd_Edges] : &vID);
  }

  if (Number_of_Trias > 0)
  {
    GmfSetKwd(Grid_File_Index,GmfTriangles,Number_of_Trias);
    GmfSetBlock(Grid_File_Index, GmfTriangles, 1, Number_of_Trias, 0, NULL, NULL,
                IntType, &Tria_Connectivity[1][0], &Tria_Connectivity[Number_of_Trias][0],
                IntType, &Tria_Connectivity[1][1], &Tria_Connectivity[Number_of_Trias][1],
                IntType, &Tria_Connectivity[1][2], &Tria_Connectivity[Number_of_Trias][2],
                IntType, Face_ID_Flag ? &Face_ID_Flag[1] : &vID, Face_ID_Flag ? &Face_ID_Flag[Number_of_Trias] : &vID);
  }

  if (Number_of_Quads > 0)
  {
    vID = 2;

    GmfSetKwd(Grid_File_Index,GmfQuadrilaterals,Number_of_Quads);
    GmfSetBlock(Grid_File_Index, GmfQuadrilaterals, 1, Number_of_Quads, 0, NULL, NULL,
                IntType, &Quad_Connectivity[1][0], &Quad_Connectivity[Number_of_Quads][0],
                IntType, &Quad_Connectivity[1][1], &Quad_Connectivity[Number_of_Quads][1],
                IntType, &Quad_Connectivity[1][2], &Quad_Connectivity[Number_of_Quads][2],
                IntType, &Quad_Connectivity[1][3], &Quad_Connectivity[Number_of_Quads][3],
                IntType, Face_ID_Flag ? &Face_ID_Flag[ Number_of_Trias + 1               ] : &vID, 
                         Face_ID_Flag ? &Face_ID_Flag[ Number_of_Trias + Number_of_Quads ] : &vID);
  }

  GmfCloseMesh(Grid_File_Index);

  return (0);

}
