#include "mesh_ug_io.h"
#include "libmeshb7.h"

INT_ mesh_ug_io_read_func (
  char File_Name[],
  INT_ Read_Task_Flag,
  INT_ NDim,
  INT_ *Number_of_Nodes,
  INT_ *Number_of_U_Scalars,
  INT_ *Number_of_U_Vectors,
  INT_ *Number_of_U_Metrics,
  INT_ *Number_of_U_SymMetrics,
  CHAR_21 * U_Scalar_Labels,
  CHAR_21 * U_Vector_Labels,
  CHAR_21 * U_Metric_Labels,
  CHAR_21 * U_SymMetric_Labels,
  DOUBLE_1D * U_Scalars,
  DOUBLE_1D * U_Vectors,
  DOUBLE_1D * U_Metrics,
  DOUBLE_1D * U_SymMetrics)
{

/*
 * Read function data from a SOL data file.
 * 
 * $Id: mesh_ug_io_read_func.c,v 1.13 2022/11/21 01:19:48 marcum Exp $
 */

  DOUBLE_1D * U_Scalar;
  DOUBLE_1D * U_Vector;
  DOUBLE_1D * U_Metric;
  DOUBLE_1D * U_SymMetric;

  int Dim, FilVer, NbrTyp, SolSiz;

  LONG_LONG_int Sol_File_Index;

  INT_ TypTab[ GmfMaxTyp ];

  INT_ i, j, n, Index;
  INT_ U_Scalar_Location = 0;
  INT_ U_Vector_Location = 0;
  INT_ U_Metric_Location = 0;
  INT_ U_SymMetric_Location = 0;

  double bufDbl[9];

  // Open SOL file and check
  
  Sol_File_Index = GmfOpenMesh (File_Name, GmfRead, &FilVer, &Dim); 
  
  if (Sol_File_Index <= 0) {
    GmfCloseMesh (Sol_File_Index);
    ug_error_message ("*** ERROR : error opening SOL file ***");
    return 1;
  }

  if (Dim != NDim) {
    GmfCloseMesh (Sol_File_Index);
    ug_error_message ("*** ERROR : SOL file dimension is not set for 3D ***");
    return 1; 
  }

  // Read array size

  if (Read_Task_Flag == 1) {

    *Number_of_Nodes = (INT_) GmfStatKwd (Sol_File_Index, GmfSolAtVertices, &NbrTyp, &SolSiz, TypTab);

    if (*Number_of_Nodes == 0) {
      ug_error_message ("*** ERROR : no vertices/nodes in SOL file ***");
      return 1;
    }

    if (NbrTyp == 0) {
      ug_error_message ("*** ERROR : SOL file contains no function data fields ***");
      return 1;
    }

    *Number_of_U_Scalars = 0;
    *Number_of_U_Vectors = 0;
    *Number_of_U_Metrics = 0;
    *Number_of_U_SymMetrics = 0;

    for (i = 0; i < NbrTyp; i++) {

      if (TypTab[i] == GmfSca) (*Number_of_U_Scalars)++;
      if (TypTab[i] == GmfVec) (*Number_of_U_Vectors)++;
      if (TypTab[i] == GmfMat) (*Number_of_U_Metrics)++;
      if (TypTab[i] == GmfSymMat) (*Number_of_U_SymMetrics)++;
    }
  }

  else if (Read_Task_Flag == 2) {

    // Set Labels

    if (U_Scalar_Labels) {

      for (Index = 0; Index < *Number_of_U_Scalars; Index++) {
        snprintf (U_Scalar_Labels[Index], sizeof (U_Scalar_Labels[Index]), "Scalar_%i", (int) (Index+1));
      }
    }

    if (U_Vector_Labels)
    {
      for (Index = 0; Index < *Number_of_U_Vectors; Index++) {
        snprintf (U_Vector_Labels[Index], sizeof(U_Vector_Labels[Index]), "Vector_%i", (int) (Index+1));
      }
    }

    if (U_Metric_Labels)
    {
      for (Index = 0; Index < *Number_of_U_Metrics; Index++) {
        snprintf (U_Metric_Labels[Index], sizeof (U_Metric_Labels[Index]), "Metric_%i", (int) (Index+1));
      }
    }

    if (U_SymMetric_Labels)
    {
      for (Index = 0; Index < *Number_of_U_SymMetrics; Index++) {
        snprintf (U_SymMetric_Labels[Index], sizeof(U_SymMetric_Labels[Index]), "SymMetric_%i", (int) (Index+1));
      }
    }
  }
 
  else if (Read_Task_Flag == 3) {

    // Read function data

    *Number_of_Nodes = (INT_) GmfStatKwd (Sol_File_Index, GmfSolAtVertices, &NbrTyp, &SolSiz, TypTab);

    GmfGotoKwd (Sol_File_Index, GmfSolAtVertices);

    for (i = 0; i < NbrTyp; i++) {

      if (TypTab[i] == GmfSca) {

        U_Scalar = &U_Scalars[U_Scalar_Location];

        for (Index = 1; Index <= *Number_of_Nodes; Index++) {

          GmfGetLin (Sol_File_Index, GmfSolAtVertices, bufDbl);

          U_Scalar[Index] = bufDbl[0];
        }

        U_Scalar_Location = U_Scalar_Location + (*Number_of_Nodes) + 1;
      }

      else if (TypTab[i] == GmfVec) {

        n = NDim;

        U_Vector = &U_Vectors[U_Vector_Location];

        for (Index = 1; Index <= *Number_of_Nodes; Index++) {

          GmfGetLin (Sol_File_Index, GmfSolAtVertices, bufDbl);

          for (j = 0; j < n; j++) {

            U_Vector[j+Index*n] = bufDbl[j];
          }
        }

        U_Vector_Location = U_Vector_Location + n * ((*Number_of_Nodes) + 1);
      }

      else if (TypTab[i] == GmfMat) {

        n = NDim*NDim;

        U_Metric = &U_Metrics[U_Metric_Location];

        for (Index = 1; Index <= *Number_of_Nodes; Index++) {

          GmfGetLin (Sol_File_Index, GmfSolAtVertices, bufDbl);

          for (j = 0; j < n; j++) {

            U_Metric[j+Index*n] =  bufDbl[j];
          }
        }

        U_Metric_Location = U_Metric_Location + n * ((*Number_of_Nodes) + 1);
      }

      else if (TypTab[i] == GmfSymMat)
      {
        n = 3*(NDim-1);

        U_SymMetric = &U_SymMetrics[U_SymMetric_Location];

        for (Index = 1; Index <= *Number_of_Nodes; Index++) {

          GmfGetLin (Sol_File_Index, GmfSolAtVertices, bufDbl);

          for (j = 0; j < n; j++) {

            U_SymMetric[j+Index*n] = bufDbl[j];
          }

          // WARNING: Gamma convention switch 2 and 3

          if (NDim == 3) {

            U_SymMetric[2+Index*n] = bufDbl[3];
            U_SymMetric[3+Index*n] = bufDbl[2];
          }
        }

        U_SymMetric_Location = U_SymMetric_Location + n * ((*Number_of_Nodes) + 1);
      }
    }
  }
  
  GmfCloseMesh (Sol_File_Index);

  Read_Task_Flag++;

  return 0;
}
