#include "mesh_ug_io.h"
#include "libmeshb7.h"

INT_ mesh_ug_io_read_2d_grid
 (char File_Name[],
  INT_ Read_Task_Flag,
  INT_ *Number_of_Bnd_Nodes,
  INT_ *Number_of_Nodes,
  INT_ *Number_of_Bnd_Edges,
  INT_ *Number_of_Quads,
  INT_ *Number_of_Trias,
  INT_1D * ID_Flag,
  INT_2D * Bnd_Edge_Connectivity,
  INT_1D * Face_ID_Flag,
  INT_4D * Quad_Connectivity,
  INT_3D * Tria_Connectivity,
  DOUBLE_2D * Coordinates)

{

/*
 * Read grid data from a 2D MESH surface grid file.
 * 
 * $Id: mesh_ug_io_read_2d_grid.c,v 1.2 2021/05/17 22:56:58 marcum Exp $
 */

  INT_ Index, vID;
  int Dim, FilVer, IntType, i1, i2, ID;
  LONG_LONG_int Grid_File_Index, li1, li2, lID;

  // Set your internal table integer size
  if(sizeof(INT_) == sizeof(LONG_int))
    IntType = GmfInt;
  else if(sizeof(INT_) == sizeof(LONG_LONG_int))
    IntType = GmfLong;
  else
  {
    ug_error_message ("*** ERROR : unsupported integer size by MESH grid reader ***");
    return (1);
  }

  Grid_File_Index = GmfOpenMesh(File_Name,GmfRead,&FilVer,&Dim);

  if ( Grid_File_Index <= 0 )
  {
    ug_error_message ("*** ERROR : error opening MESH grid file ***");
    return (1);
  }

  if ( Dim != 2 )
  {
    GmfCloseMesh(Grid_File_Index);
    ug_error_message ("*** ERROR : MESH grid file dimension is not set for 2D ***");
    return (1);
  }

/*if (FilVer == 4 && sizeof(INT_) == 4)
  {
    GmfCloseMesh(Grid_File_Index);
    ug_error_message ("*** ERROR : MESH grid file is version 3 and requires 64-bit code ***");
    return (1);
  }*/

  if (Read_Task_Flag == 1) {

    *Number_of_Nodes     = (INT_) GmfStatKwd(Grid_File_Index,GmfVertices);
    *Number_of_Bnd_Edges = (INT_) GmfStatKwd(Grid_File_Index,GmfEdges);
    *Number_of_Quads     = (INT_) GmfStatKwd(Grid_File_Index,GmfQuadrilaterals);
    *Number_of_Trias     = (INT_) GmfStatKwd(Grid_File_Index,GmfTriangles);

    if (*Number_of_Bnd_Nodes == -1)
    {
      *Number_of_Bnd_Nodes = 0;

      GmfGotoKwd (Grid_File_Index,GmfEdges);

      for (Index = 1; Index <= *Number_of_Bnd_Edges; ++Index)
      {
        if(FilVer <= 3)
        {
          GmfGetLin(Grid_File_Index,GmfEdges,&i1,&i2,&ID);

          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i1);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i2);
        }
        else
        {
          GmfGetLin(Grid_File_Index,GmfEdges,&li1,&li2,&lID);

          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li1);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li2);
        }
      }

      *Number_of_Nodes = *Number_of_Bnd_Nodes;
      *Number_of_Quads = 0;
      *Number_of_Trias = 0;
    }
  }
  else
  {
    if (*Number_of_Bnd_Nodes > 0)
      *Number_of_Nodes = *Number_of_Bnd_Nodes;

    GmfGetBlock(Grid_File_Index, GmfVertices, 1, *Number_of_Nodes, 0, NULL, NULL,
                GmfDouble, &Coordinates[1][0], &Coordinates[*Number_of_Nodes][0],
                GmfDouble, &Coordinates[1][1], &Coordinates[*Number_of_Nodes][1],
                IntType, &vID, &vID);

    GmfGetBlock(Grid_File_Index, GmfEdges, 1, *Number_of_Bnd_Edges, 0, NULL, NULL,
                IntType, &Bnd_Edge_Connectivity[1][0], &Bnd_Edge_Connectivity[*Number_of_Bnd_Edges][0],
                IntType, &Bnd_Edge_Connectivity[1][1], &Bnd_Edge_Connectivity[*Number_of_Bnd_Edges][1],
                IntType, ID_Flag ? &ID_Flag[1] : &vID, ID_Flag ? &ID_Flag[*Number_of_Bnd_Edges] : &vID);

    if (Read_Task_Flag == 2 && *Number_of_Bnd_Nodes == 0)
    {
      GmfGetBlock(Grid_File_Index, GmfTriangles, 1, *Number_of_Trias, 0, NULL, NULL,
                  IntType, &Tria_Connectivity[1][0], &Tria_Connectivity[*Number_of_Trias][0],
                  IntType, &Tria_Connectivity[1][1], &Tria_Connectivity[*Number_of_Trias][1],
                  IntType, &Tria_Connectivity[1][2], &Tria_Connectivity[*Number_of_Trias][2],
                  IntType, Face_ID_Flag ? &Face_ID_Flag[1] : &vID, Face_ID_Flag ? &Face_ID_Flag[*Number_of_Trias] : &vID);

      GmfGetBlock(Grid_File_Index, GmfQuadrilaterals, 1, *Number_of_Quads, 0, NULL, NULL,
                  IntType, &Quad_Connectivity[1][0], &Quad_Connectivity[*Number_of_Quads][0],
                  IntType, &Quad_Connectivity[1][1], &Quad_Connectivity[*Number_of_Quads][1],
                  IntType, &Quad_Connectivity[1][2], &Quad_Connectivity[*Number_of_Quads][2],
                  IntType, &Quad_Connectivity[1][3], &Quad_Connectivity[*Number_of_Quads][3],
                  IntType, Face_ID_Flag ? &Face_ID_Flag[ *Number_of_Trias + 1                ] : &vID,
                           Face_ID_Flag ? &Face_ID_Flag[ *Number_of_Trias + *Number_of_Quads ] : &vID);
    }
  }

  GmfCloseMesh(Grid_File_Index);

  return (0);

}
