#include "mesh_ug_io.h"
#include "libmeshb7.h"

INT_ mesh_ug_io_p2_read_grid (char File_Name[],
                              INT_ Read_Task_Flag,
                              INT_ *Number_of_Bnd_Nodes,
                              INT_ *Number_of_Nodes,
                              INT_ *Number_of_Surf_Quads,
                              INT_ *Number_of_Surf_Trias,
                              INT_ *Number_of_Vol_Hexs,
                              INT_ *Number_of_Vol_Pents_5,
                              INT_ *Number_of_Vol_Pents_6,
                              INT_ *Number_of_Vol_Tets,
                              INT_ *Order,
                              INT_1D * Surf_ID_Flag,
                              INT_4D * Surf_Quad_Connectivity,
                              INT_3D * Surf_Tria_Connectivity,
                              INT_8D * Vol_Hex_Connectivity,
                              INT_1D * Vol_ID_Flag,
                              INT_5D * Vol_Pent_5_Connectivity,
                              INT_6D * Vol_Pent_6_Connectivity,
                              INT_4D * Vol_Tet_Connectivity,
                              INT_5D * P2_Surf_Quad_Connectivity,
                              INT_3D * P2_Surf_Tria_Connectivity,
                              INT_19D * P2_Vol_Hex_Connectivity,
                              INT_9D * P2_Vol_Pent_5_Connectivity,
                              INT_12D * P2_Vol_Pent_6_Connectivity,
                              INT_6D * P2_Vol_Tet_Connectivity,
                              DOUBLE_3D * Coordinates)
{

/*
 * Read grid data from a MESH surface grid file.
 * 
 * $Id: mesh_ug_io_p2_read_grid.c,v 1.10 2021/05/17 22:56:58 marcum Exp $
 */

  INT_ Index, Number_of_P2_Surf_Quads, Number_of_P2_Surf_Trias,
       Number_of_P2_Vol_Hexs,  Number_of_P2_Vol_Pents_5,
       Number_of_P2_Vol_Pents_6, Number_of_P2_Vol_Tets,
       vID;
  int Dim, FilVer, IntType, i1, i2, i3, i4, i5, i6, ID;
  LONG_LONG_int Grid_File_Index, li1, li2, li3, li4, li5, li6, lID;

  // Set your internal table integer size
  if(sizeof(INT_) == sizeof(LONG_int))
    IntType = GmfInt;
  else if(sizeof(INT_) == sizeof(LONG_LONG_int))
    IntType = GmfLong;
  else
  {
    ug_error_message ("*** ERROR : unsupported integer size by MESH grid reader ***");
    return (1);
  }

  Grid_File_Index = GmfOpenMesh(File_Name,GmfRead,&FilVer,&Dim); 

  if ( Grid_File_Index <= 0 ) 
  {
    ug_error_message ("*** ERROR : error opening MESH grid file ***");
    return (1);
  }

  if ( Dim != 3 ) 
  {
    GmfCloseMesh(Grid_File_Index);
    ug_error_message ("*** ERROR : MESH grid file dimension is not set for 3D ***");
    return (1); 
  }
/*
  if (FilVer == 4 && sizeof(INT_) == 4)
  {
    GmfCloseMesh(Grid_File_Index);
    ug_error_message ("*** ERROR : MESH grid file is version 3 and requires 64-bit code ***");
    return (1); 
  }
*/
  if (Read_Task_Flag == 1) {
  
    *Number_of_Nodes         = (INT_) GmfStatKwd(Grid_File_Index,GmfVertices);
    *Number_of_Surf_Quads    = (INT_) GmfStatKwd(Grid_File_Index,GmfQuadrilaterals); 
    *Number_of_Surf_Trias    = (INT_) GmfStatKwd(Grid_File_Index,GmfTriangles);
    *Number_of_Vol_Tets      = (INT_) GmfStatKwd(Grid_File_Index,GmfTetrahedra); 
    *Number_of_Vol_Hexs      = (INT_) GmfStatKwd(Grid_File_Index,GmfHexahedra);
    *Number_of_Vol_Pents_5   = (INT_) GmfStatKwd(Grid_File_Index,GmfPyramids);
    *Number_of_Vol_Pents_6   = (INT_) GmfStatKwd(Grid_File_Index,GmfPrisms);

    Number_of_P2_Surf_Quads    = (INT_) GmfStatKwd(Grid_File_Index,GmfQuadrilateralsQ2); 
    Number_of_P2_Surf_Trias    = (INT_) GmfStatKwd(Grid_File_Index,GmfTrianglesP2);
    Number_of_P2_Vol_Tets      = (INT_) GmfStatKwd(Grid_File_Index,GmfTetrahedraP2); 
    Number_of_P2_Vol_Hexs      = (INT_) GmfStatKwd(Grid_File_Index,GmfHexahedraQ2);
    Number_of_P2_Vol_Pents_5   = (INT_) GmfStatKwd(Grid_File_Index,GmfPyramidsP2);
    Number_of_P2_Vol_Pents_6   = (INT_) GmfStatKwd(Grid_File_Index,GmfPrismsP2);

    *Order = (Number_of_P2_Surf_Trias || Number_of_P2_Vol_Tets) ? 2: 1;

    if (*Order == 2 && (*Number_of_Surf_Trias || *Number_of_Vol_Tets))
    {
      GmfCloseMesh(Grid_File_Index);
      ug_error_message ("*** ERROR : MESH grid file with mixed P1 and P2 faces or elements not supported ***");
      return (1); 
    }

    if (Number_of_P2_Surf_Quads || Number_of_P2_Vol_Hexs || Number_of_P2_Vol_Pents_5 || Number_of_P2_Vol_Pents_6)
    {
      GmfCloseMesh(Grid_File_Index);
      ug_error_message ("*** ERROR : MESH grid file with P2-quads, hexes, pyramids, or prisms not supported ***");
      return (1); 
    }

    if (Number_of_P2_Surf_Trias)
      *Number_of_Surf_Trias = Number_of_P2_Surf_Trias;

    if (Number_of_P2_Vol_Tets)
      *Number_of_Vol_Tets = Number_of_P2_Vol_Tets;

    if (*Number_of_Bnd_Nodes == -1)
    {
      *Number_of_Bnd_Nodes = 0;

      if (*Order == 1)
        GmfGotoKwd(Grid_File_Index,GmfTriangles);
      else
        GmfGotoKwd(Grid_File_Index,GmfTrianglesP2);

      for (Index = 1; Index <= *Number_of_Surf_Trias; ++Index)
      {
        if(FilVer <= 3)
        {
          if (*Order == 1)
            GmfGetLin(Grid_File_Index,GmfTriangles,&i1,&i2,&i3,&ID);
          else
            GmfGetLin(Grid_File_Index,GmfTrianglesP2,&i1,&i2,&i3,&i4,&i5,&i6,&ID);

          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i1);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i2);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i3);

          if (*Order == 2)
          {
            *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i4);
            *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i5);
            *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i6);
          }
        }
        else
        {
          if (*Order == 1)
            GmfGetLin(Grid_File_Index,GmfTriangles,&li1,&li2,&li3,&ID);
          else
            GmfGetLin(Grid_File_Index,GmfTrianglesP2,&li1,&li2,&li3,&li4,&li5,&li6,&ID);

          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li1);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li2);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li3);

          if (*Order == 2)
          {
            *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li4);
            *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li5);
            *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li6);
          }
        }
      }
    
      GmfGotoKwd(Grid_File_Index,GmfQuadrilaterals);

      for (Index = 1; Index <= *Number_of_Surf_Quads; ++Index)
      {
        if(FilVer <= 3)
        {
          GmfGetLin(Grid_File_Index,GmfQuadrilaterals,&i1,&i2,&i3,&i4,&ID);

          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i1);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i2);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i3);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) i4);
        }
        else
        {
          GmfGetLin(Grid_File_Index,GmfQuadrilaterals,&li1,&li2,&li3,&li4,&lID);

          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li1);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li2);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li3);
          *Number_of_Bnd_Nodes = MAX (*Number_of_Bnd_Nodes, (INT_) li4);
        }
      }

      *Number_of_Nodes = *Number_of_Bnd_Nodes;
      *Number_of_Vol_Hexs = 0;
      *Number_of_Vol_Pents_5 = 0;
      *Number_of_Vol_Pents_6 = 0;
      *Number_of_Vol_Tets = 0;
    }
  }
  else 
  {
    if (*Number_of_Bnd_Nodes > 0)
      *Number_of_Nodes = *Number_of_Bnd_Nodes;

    GmfGetBlock(Grid_File_Index, GmfVertices, 1, *Number_of_Nodes, 0, NULL, NULL,
                GmfDouble, &Coordinates[1][0], &Coordinates[*Number_of_Nodes][0],
                GmfDouble, &Coordinates[1][1], &Coordinates[*Number_of_Nodes][1],
                GmfDouble, &Coordinates[1][2], &Coordinates[*Number_of_Nodes][2],
                IntType, &vID, &vID);

    if (*Order == 1)
      GmfGetBlock(Grid_File_Index, GmfTriangles, 1, *Number_of_Surf_Trias, 0, NULL, NULL,
                  IntType, &Surf_Tria_Connectivity[1][0], &Surf_Tria_Connectivity[*Number_of_Surf_Trias][0],
                  IntType, &Surf_Tria_Connectivity[1][1], &Surf_Tria_Connectivity[*Number_of_Surf_Trias][1],
                  IntType, &Surf_Tria_Connectivity[1][2], &Surf_Tria_Connectivity[*Number_of_Surf_Trias][2],
                  IntType, Surf_ID_Flag ? &Surf_ID_Flag[1] : &vID, Surf_ID_Flag ? &Surf_ID_Flag[*Number_of_Surf_Trias] : &vID);
    else
      GmfGetBlock(Grid_File_Index, GmfTrianglesP2, 1, *Number_of_Surf_Trias, 0, NULL, NULL,
                  IntType, &Surf_Tria_Connectivity[1][0], &Surf_Tria_Connectivity[*Number_of_Surf_Trias][0],
                  IntType, &Surf_Tria_Connectivity[1][1], &Surf_Tria_Connectivity[*Number_of_Surf_Trias][1],
                  IntType, &Surf_Tria_Connectivity[1][2], &Surf_Tria_Connectivity[*Number_of_Surf_Trias][2],
                  IntType, &P2_Surf_Tria_Connectivity[1][2], &P2_Surf_Tria_Connectivity[*Number_of_Surf_Trias][2], // undo PLG/Vizir ordering
                  IntType, &P2_Surf_Tria_Connectivity[1][0], &P2_Surf_Tria_Connectivity[*Number_of_Surf_Trias][0], // undo PLG/Vizir ordering
                  IntType, &P2_Surf_Tria_Connectivity[1][1], &P2_Surf_Tria_Connectivity[*Number_of_Surf_Trias][1], // undo PLG/Vizir ordering
                  IntType, Surf_ID_Flag ? &Surf_ID_Flag[1] : &vID, Surf_ID_Flag ? &Surf_ID_Flag[*Number_of_Surf_Trias] : &vID);

    GmfGetBlock(Grid_File_Index, GmfQuadrilaterals, 1, *Number_of_Surf_Quads, 0, NULL, NULL,
                IntType, &Surf_Quad_Connectivity[1][0], &Surf_Quad_Connectivity[*Number_of_Surf_Quads][0],
                IntType, &Surf_Quad_Connectivity[1][1], &Surf_Quad_Connectivity[*Number_of_Surf_Quads][1],
                IntType, &Surf_Quad_Connectivity[1][2], &Surf_Quad_Connectivity[*Number_of_Surf_Quads][2],
                IntType, &Surf_Quad_Connectivity[1][3], &Surf_Quad_Connectivity[*Number_of_Surf_Quads][3],
                IntType, Surf_ID_Flag ? &Surf_ID_Flag[ *Number_of_Surf_Trias + 1                     ] : &vID, \
                         Surf_ID_Flag ? &Surf_ID_Flag[ *Number_of_Surf_Trias + *Number_of_Surf_Quads ] : &vID);

    if (Read_Task_Flag == 2 && *Number_of_Bnd_Nodes == 0)
    {
      if (*Order == 1)
        GmfGetBlock(Grid_File_Index, GmfTetrahedra, 1, *Number_of_Vol_Tets, 0, NULL, NULL,
                    IntType, &Vol_Tet_Connectivity[1][0], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][0],
                    IntType, &Vol_Tet_Connectivity[1][1], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][1],
                    IntType, &Vol_Tet_Connectivity[1][2], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][2],
                    IntType, &Vol_Tet_Connectivity[1][3], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][3],
                    IntType, Vol_ID_Flag ? &Vol_ID_Flag[1] : &vID, Vol_ID_Flag ? &Vol_ID_Flag[*Number_of_Vol_Tets] : &vID);
      else
        GmfGetBlock(Grid_File_Index, GmfTetrahedraP2, 1, *Number_of_Vol_Tets, 0, NULL, NULL,
                    IntType, &Vol_Tet_Connectivity[1][0], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][0],
                    IntType, &Vol_Tet_Connectivity[1][1], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][1],
                    IntType, &Vol_Tet_Connectivity[1][2], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][2],
                    IntType, &Vol_Tet_Connectivity[1][3], &Vol_Tet_Connectivity[*Number_of_Vol_Tets][3],
                    IntType, &P2_Vol_Tet_Connectivity[1][0], &P2_Vol_Tet_Connectivity[*Number_of_Vol_Tets][0], // undo PLG/Vizir ordering
                    IntType, &P2_Vol_Tet_Connectivity[1][3], &P2_Vol_Tet_Connectivity[*Number_of_Vol_Tets][3], // undo PLG/Vizir ordering
                    IntType, &P2_Vol_Tet_Connectivity[1][1], &P2_Vol_Tet_Connectivity[*Number_of_Vol_Tets][1], // undo PLG/Vizir ordering
                    IntType, &P2_Vol_Tet_Connectivity[1][2], &P2_Vol_Tet_Connectivity[*Number_of_Vol_Tets][2], // undo PLG/Vizir ordering
                    IntType, &P2_Vol_Tet_Connectivity[1][4], &P2_Vol_Tet_Connectivity[*Number_of_Vol_Tets][4], // undo PLG/Vizir ordering
                    IntType, &P2_Vol_Tet_Connectivity[1][5], &P2_Vol_Tet_Connectivity[*Number_of_Vol_Tets][5], // undo PLG/Vizir ordering
                    IntType, Vol_ID_Flag ? &Vol_ID_Flag[1] : &vID, Vol_ID_Flag ? &Vol_ID_Flag[*Number_of_Vol_Tets] : &vID);

      GmfGetBlock(Grid_File_Index, GmfPyramids, 1, *Number_of_Vol_Pents_5, 0, NULL, NULL,
                  IntType, &Vol_Pent_5_Connectivity[1][0], &Vol_Pent_5_Connectivity[*Number_of_Vol_Pents_5][0],
                  IntType, &Vol_Pent_5_Connectivity[1][1], &Vol_Pent_5_Connectivity[*Number_of_Vol_Pents_5][1],
                  IntType, &Vol_Pent_5_Connectivity[1][2], &Vol_Pent_5_Connectivity[*Number_of_Vol_Pents_5][2],
                  IntType, &Vol_Pent_5_Connectivity[1][3], &Vol_Pent_5_Connectivity[*Number_of_Vol_Pents_5][3],
                  IntType, &Vol_Pent_5_Connectivity[1][4], &Vol_Pent_5_Connectivity[*Number_of_Vol_Pents_5][4],
                  IntType, Vol_ID_Flag ? &Vol_ID_Flag[ *Number_of_Vol_Tets + 1                      ] : &vID,
                           Vol_ID_Flag ? &Vol_ID_Flag[ *Number_of_Vol_Tets + *Number_of_Vol_Pents_5 ] : &vID);

      GmfGetBlock(Grid_File_Index, GmfPrisms, 1, *Number_of_Vol_Pents_6, 0, NULL, NULL,
                  IntType, &Vol_Pent_6_Connectivity[1][0], &Vol_Pent_6_Connectivity[*Number_of_Vol_Pents_6][0],
                  IntType, &Vol_Pent_6_Connectivity[1][1], &Vol_Pent_6_Connectivity[*Number_of_Vol_Pents_6][1],
                  IntType, &Vol_Pent_6_Connectivity[1][2], &Vol_Pent_6_Connectivity[*Number_of_Vol_Pents_6][2],
                  IntType, &Vol_Pent_6_Connectivity[1][3], &Vol_Pent_6_Connectivity[*Number_of_Vol_Pents_6][3],
                  IntType, &Vol_Pent_6_Connectivity[1][4], &Vol_Pent_6_Connectivity[*Number_of_Vol_Pents_6][4],
                  IntType, &Vol_Pent_6_Connectivity[1][5], &Vol_Pent_6_Connectivity[*Number_of_Vol_Pents_6][5],
                  IntType, Vol_ID_Flag ? &Vol_ID_Flag[ *Number_of_Vol_Tets + *Number_of_Vol_Pents_5 + 1                      ] : &vID,
                           Vol_ID_Flag ? &Vol_ID_Flag[ *Number_of_Vol_Tets + *Number_of_Vol_Pents_5 + *Number_of_Vol_Pents_6 ] : &vID);

      GmfGetBlock(Grid_File_Index, GmfHexahedra, 1, *Number_of_Vol_Hexs, 0, NULL, NULL,
                  IntType, &Vol_Hex_Connectivity[1][0], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][0],
                  IntType, &Vol_Hex_Connectivity[1][1], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][1],
                  IntType, &Vol_Hex_Connectivity[1][2], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][2],
                  IntType, &Vol_Hex_Connectivity[1][3], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][3],
                  IntType, &Vol_Hex_Connectivity[1][4], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][4],
                  IntType, &Vol_Hex_Connectivity[1][5], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][5],
                  IntType, &Vol_Hex_Connectivity[1][6], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][6],
                  IntType, &Vol_Hex_Connectivity[1][7], &Vol_Hex_Connectivity[*Number_of_Vol_Hexs][7],
                  IntType, Vol_ID_Flag ? &Vol_ID_Flag[ *Number_of_Vol_Tets + *Number_of_Vol_Pents_5 + *Number_of_Vol_Pents_6 + 1                   ] : &vID,
                           Vol_ID_Flag ? &Vol_ID_Flag[ *Number_of_Vol_Tets + *Number_of_Vol_Pents_5 + *Number_of_Vol_Pents_6 + *Number_of_Vol_Hexs ] : &vID);
    }
  }

  GmfCloseMesh(Grid_File_Index);

  return (0);

}
