#include "cgns_ug_io.h"
#include "cgnslib.h"

INT_ cgns_ug_io_write_grid
 (char Case_Name[],
  char Grid_File_Name[],
  INT_ Number_of_BL_Vol_Tets,
  INT_ Number_of_Nodes,
  INT_ Number_of_Surf_Quads,
  INT_ Number_of_Surf_Trias,
  INT_ Number_of_Vol_Hexs,
  INT_ Number_of_Vol_Pents_5,
  INT_ Number_of_Vol_Pents_6,
  INT_ Number_of_Vol_Tets,
  INT_1D * Surf_Grid_BC_Flag,
  INT_1D * Surf_ID_Flag,
  INT_4D * Surf_Quad_Connectivity,
  INT_1D * Surf_Reonnection_Flag,
  INT_3D * Surf_Tria_Connectivity,
  INT_8D * Vol_Hex_Connectivity,
  INT_1D * Vol_ID_Flag,
  INT_5D * Vol_Pent_5_Connectivity,
  INT_6D * Vol_Pent_6_Connectivity,
  INT_4D * Vol_Tet_Connectivity,
  DOUBLE_3D * Coordinates,
  DOUBLE_1D * Initial_Normal_Spacing,
  DOUBLE_1D * BL_Thickness)

{

/*
 * Write volume or surface grid data to a CGNS file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: cgns_ug_io_write_grid.c,v 1.8 2022/11/21 01:16:26 marcum Exp $
 */

  FILE *Tags_File;

  char Label[33];
  CHAR_UG_MAX Tags_File_Name;

  CHAR_81 Text_Line;
  CHAR_81 *Tag_Name_List = NULL;

  INT_1D *Surf_ID_List = NULL;
  INT_1D *Tag_ID_List = NULL;

  INT_ Index, Index_1, Index_2, Index_3, Index_4, Index_5, Found_Flag,
       List_Index, Local_Index, Number_of_Surf_Faces, Number_of_Surf_IDs,
       Number_of_Tag_ID_List, Read_Flag, Surf_ID, Surf_ID_Max, Surf_ID_Min,
       Tag_ID;
  
  INT_ Error_Flag = 0;

  int *Connectivity = NULL;

  int Zone_Size[3][3];

  int Array_Size, Base_Index, Coordinate_Index, End_Index, File_Index,
      Number_of_Boundary_Items, Section_Index, Start_Index, true_int,
      Zone_Index;

  double *Coordinate = NULL;

  Number_of_Boundary_Items = 0;
 
  Error_Flag = cg_open (Grid_File_Name, CG_MODE_WRITE, &File_Index);

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR : unable to open CGNS grid file ***");
    return (1);
  }

  Error_Flag = cg_base_write (File_Index, "Base", 3, 3, &Base_Index);

  if (Error_Flag > 0)
  {
    cg_close(File_Index);
    ug_error_message ("*** ERROR : error writing CGNS grid file ***");
    return (1);
  }

  Zone_Size[0][0] = (int) Number_of_Nodes;
  Zone_Size[0][1] = (int) (Number_of_Vol_Tets
                         + Number_of_Vol_Pents_5 + Number_of_Vol_Pents_6
                         + Number_of_Vol_Hexs
                         + Number_of_Surf_Trias + Number_of_Surf_Quads);
                        
  Zone_Size[0][2] = 0;
  Zone_Size[1][0] = 0;
  Zone_Size[1][1] = 0;
  Zone_Size[1][2] = 0;
  Zone_Size[2][0] = 0;
  Zone_Size[2][1] = 0;
  Zone_Size[2][2] = 0;

  Error_Flag = cg_zone_write (File_Index, Base_Index, "Zone 1", *Zone_Size,
                              Unstructured, &Zone_Index);

  if (Error_Flag > 0)
  {
    cg_close(File_Index);
    ug_error_message ("*** ERROR : error writing CGNS grid file ***");
    return (1);
  }

  Array_Size = Number_of_Nodes * (INT_) sizeof (double);

  Coordinate = (double *) ug_malloc (&Error_Flag, Array_Size);

  if (Error_Flag > 0)
  {
    ug_free (Coordinate);
    cg_close(File_Index);
    ug_error_message ("*** ERROR : unable to malloc CGNS I/O work array ***");
    return (1);
  }
 
  for (Index = 1; Index <= Number_of_Nodes; ++Index)
  {
    Coordinate[Index-1] = Coordinates[Index][0];
  }  
 
  Error_Flag = cg_coord_write (File_Index, Base_Index, Zone_Index, RealDouble,
                               "CoordinateX", Coordinate, &Coordinate_Index);

  if (Error_Flag > 0)
  {
    ug_free (Coordinate);
    cg_close(File_Index);
    ug_error_message ("*** ERROR : error writing CGNS grid file ***");
    return (1);
  }
 
  for (Index = 1; Index <= Number_of_Nodes; ++Index)
  {
    Coordinate[Index-1] = Coordinates[Index][1];
  }  
 
  Error_Flag = cg_coord_write (File_Index, Base_Index, Zone_Index, RealDouble,
                               "CoordinateY", Coordinate, &Coordinate_Index);

  if (Error_Flag > 0)
  {
    ug_free (Coordinate);
    cg_close(File_Index);
    ug_error_message ("*** ERROR : error writing CGNS grid file ***");
    return (1);
  }

  for (Index = 1; Index <= Number_of_Nodes; ++Index)
  {
    Coordinate[Index-1] = Coordinates[Index][2];
  }  
 
  Error_Flag = cg_coord_write (File_Index, Base_Index, Zone_Index, RealDouble,
                               "CoordinateZ", Coordinate, &Coordinate_Index);

  if (Error_Flag > 0)
  {
    ug_free (Coordinate);
    cg_close(File_Index);
    ug_error_message ("*** ERROR : error writing CGNS grid file ***");
    return (1);
  }

  ug_free (Coordinate);

  Number_of_Surf_Faces = Number_of_Surf_Trias + Number_of_Surf_Quads;

  Surf_ID_Max = Surf_ID_Flag[1];
  Surf_ID_Min = Surf_ID_Flag[1];

  for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
  {
    Surf_ID = Surf_ID_Flag[Index];

    Surf_ID_Max = MAX (Surf_ID, Surf_ID_Max);
    Surf_ID_Min = MIN (Surf_ID, Surf_ID_Min);
  }

  Number_of_Surf_IDs = 0;

  for (Surf_ID = Surf_ID_Min; Surf_ID <= Surf_ID_Max; ++Surf_ID)
  {
    Found_Flag = 0;

    Index = 1;

    do
    {
      if (Surf_ID == Surf_ID_Flag[Index]) Found_Flag = 1;

      ++Index;
    }
    while (Index <= Number_of_Surf_Faces && Found_Flag == 0);

    if (Found_Flag == 1)
      ++Number_of_Surf_IDs;
  }

  Array_Size = Number_of_Surf_IDs * (INT_) sizeof (int);

  Surf_ID_List  = (int *) ug_malloc (&Error_Flag, Array_Size);

  if (Error_Flag > 0)
  {
    ug_free (Surf_ID_List);
    cg_close(File_Index);
    ug_error_message ("*** ERROR : unable to malloc CGNS I/O work array ***");
    return (1);
  }

  List_Index = 0;

  for (Surf_ID = Surf_ID_Min; Surf_ID <= Surf_ID_Max; ++Surf_ID)
  {
    Found_Flag = 0;

    Index = 1;

    do
    {
      if (Surf_ID == Surf_ID_Flag[Index]) Found_Flag = 1;

      ++Index;
    }
    while (Index <= Number_of_Surf_Faces && Found_Flag == 0);

    if (Found_Flag == 1)
    {
      Surf_ID_List[List_Index] = Surf_ID;

      ++List_Index;
    }
  }

  Array_Size = MAX (3*Number_of_Surf_Trias, 4*Number_of_Surf_Quads)
             * (INT_) sizeof (int);

  Connectivity = (int *) ug_malloc (&Error_Flag, Array_Size);

  if (Error_Flag > 0)
  {
    ug_free (Surf_ID_List);
    ug_free (Connectivity);
    cg_close(File_Index);
    ug_error_message ("*** ERROR : unable to malloc CGNS I/O work array ***");
    return (1);
  }

  Number_of_Tag_ID_List = 0;

  strcpy (Tags_File_Name, Case_Name);
  strcat (Tags_File_Name, ".tags");

  Tags_File = ug_fopen (Tags_File_Name, "r");

  if (Tags_File != NULL)
  {
    Index = 0;
    while (!feof(Tags_File))
    {
      if (fgets(Text_Line, UG_MAX_CHAR_STRING_LENGTH, Tags_File) != NULL)
      {
	if (strncmp(Text_Line, "#", 1))
	  ++Index;
	else if (isdigit(Text_Line[1]))
	  ++Index;
      }
    }

    Number_of_Tag_ID_List = Index;

    if (Number_of_Tag_ID_List > 0)
    {
      Error_Flag = 0;

      Array_Size = (Number_of_Tag_ID_List+1) * sizeof (INT_1D);

      Tag_ID_List = (INT_1D *) ug_malloc (&Error_Flag, Array_Size);

      Array_Size = (Number_of_Tag_ID_List+1) * sizeof (CHAR_81);

      Tag_Name_List = (CHAR_81 *) ug_malloc (&Error_Flag, Array_Size);

      if (Error_Flag != 0)
      {
        ug_free (Tag_ID_List);
        ug_free (Tag_Name_List);

        Number_of_Tag_ID_List = 0;
      }
      else
      {
        rewind (Tags_File);

	Index = 0;
        while (!feof(Tags_File))
        {
	  if (fgets(Text_Line, UG_MAX_CHAR_STRING_LENGTH, Tags_File) != NULL)
	  {
	    if (strncmp(Text_Line, "#", 1))
	    {
	      ++Index;
	      Read_Flag = sscanf (Text_Line, "%d %s",
				  &true_int,&Tag_Name_List[Index][0]);
	      if (Read_Flag != 2)
	      {
		ug_free (Tag_ID_List);
		ug_free (Tag_Name_List);
		ug_free (Surf_ID_List);
		ug_free (Connectivity);
		cg_close(File_Index);
		ug_error_message ("*** ERROR : unable to read tags file ***");
		return (1);
	      }

	      Tag_ID_List[Index] = (INT_) true_int;
	    }
	    else if (isdigit(Text_Line[1]))
	    {
	      ++Index;
	      Read_Flag = sscanf (Text_Line, "#%i: %s",
				  &true_int, &Tag_Name_List[Index][0]);
	      if (Read_Flag != 2)
	      {
		ug_free (Tag_ID_List);
		ug_free (Tag_Name_List);
		ug_free (Surf_ID_List);
		ug_free (Connectivity);
		cg_close(File_Index);
		ug_error_message ("*** ERROR : unable to read tags file ***");
		return (1);
	      }

	      Tag_ID_List[Index] = (INT_) true_int;
	    }
	  }
        }
      }
    }

    ug_fclose (Tags_File);
  }

  End_Index = 0;

  if (Number_of_Surf_Trias != 0)
  {
    for (List_Index = 0; List_Index < Number_of_Surf_IDs; ++List_Index)
    {
      Surf_ID = Surf_ID_List[List_Index];
        
      Local_Index = 0;

      for (Index = 1; Index <= Number_of_Surf_Trias; ++Index)
      {
        if (Surf_ID_Flag[Index] == Surf_ID)
        {
          Connectivity[Local_Index*3  ] = Surf_Tria_Connectivity[Index][0];
          Connectivity[Local_Index*3+1] = Surf_Tria_Connectivity[Index][1];
          Connectivity[Local_Index*3+2] = Surf_Tria_Connectivity[Index][2];

          ++Local_Index;
        }
      }

      if (Local_Index > 0)
      {
        Start_Index = End_Index + 1;

        End_Index = Start_Index + Local_Index - 1;

        if (Number_of_Tag_ID_List > 0)
        {
          Index = 1;

          do
          {
            Tag_ID = Tag_ID_List[Index];

            if (Tag_ID == Surf_ID)
              snprintf (Label, sizeof(Label), "Tria-%i-%s", Tag_ID, Tag_Name_List[Index]);

            ++Index;
          }
          while (Index <= Number_of_Tag_ID_List && Tag_ID != Surf_ID);
        }
        else
          snprintf (Label, sizeof(Label), "Tria-%i-Bndry", Surf_ID);

        Error_Flag = cg_section_write (File_Index, Base_Index, Zone_Index,
                                       Label, TRI_3, Start_Index, End_Index,
                                       Number_of_Boundary_Items,
                                       Connectivity, &Section_Index);

        if (Error_Flag > 0)
        {
          if (Number_of_Tag_ID_List > 0)
          {
            ug_free (Tag_ID_List);
            ug_free (Tag_Name_List);
          }
          ug_free (Connectivity);
          ug_free (Surf_ID_List);
          cg_close(File_Index);
          if (Number_of_Tag_ID_List > 0)
            ug_error_message ("*** ERROR : error writing CGNS grid file using TAGS file info ***");
          else
            ug_error_message ("*** ERROR : error writing CGNS grid file ***");
          return (1);
        }
      }
    }
  }
 
  if (Number_of_Surf_Quads != 0)
  {
    for (List_Index = 0; List_Index < Number_of_Surf_IDs; ++List_Index)
    {
      Surf_ID = Surf_ID_List[List_Index];
        
      Local_Index = 0;

      for (Index = 1; Index <= Number_of_Surf_Quads; ++Index)
      {
        if (Surf_ID_Flag[Index+Number_of_Surf_Trias] == Surf_ID)
        {
          Connectivity[Local_Index*4  ] = Surf_Quad_Connectivity[Index][0];
          Connectivity[Local_Index*4+1] = Surf_Quad_Connectivity[Index][1];
          Connectivity[Local_Index*4+2] = Surf_Quad_Connectivity[Index][2];
          Connectivity[Local_Index*4+3] = Surf_Quad_Connectivity[Index][3];

          ++Local_Index;
        }
      }

      if (Local_Index > 0)
      {
        Start_Index = End_Index + 1;

        End_Index = Start_Index + Local_Index - 1;

        if (Number_of_Tag_ID_List > 0)
        {
          Index = 1;

          do
          {
            Tag_ID = Tag_ID_List[Index];

            if (Tag_ID == Surf_ID)
              snprintf (Label, sizeof(Label), "Quad-%i-%s", Tag_ID, Tag_Name_List[Index]);

            ++Index;
          }
          while (Index <= Number_of_Tag_ID_List && Tag_ID != Surf_ID);
        }
        else
          snprintf (Label, sizeof(Label), "Quad-%i-Bndry", Surf_ID);

        Error_Flag = cg_section_write (File_Index, Base_Index, Zone_Index,
                                       Label, QUAD_4, Start_Index, End_Index,
                                       Number_of_Boundary_Items,
                                       Connectivity, &Section_Index);

        if (Error_Flag > 0)
        {
          if (Number_of_Tag_ID_List > 0)
          {
            ug_free (Tag_ID_List);
            ug_free (Tag_Name_List);
          }
          ug_free (Connectivity);
          ug_free (Surf_ID_List);
          cg_close(File_Index);
          if (Number_of_Tag_ID_List > 0)
            ug_error_message ("*** ERROR : error writing CGNS grid file using TAGS file info ***");
          else
            ug_error_message ("*** ERROR : error writing CGNS grid file ***");
          return (1);
        }
      }
    }
  }

  if (Number_of_Tag_ID_List > 0)
  {
    ug_free (Tag_ID_List);
    ug_free (Tag_Name_List);
  }

  ug_free (Connectivity);

  ug_free (Surf_ID_List);
  
  if (Number_of_Vol_Tets != 0)
  {
    Start_Index = End_Index + 1;

    End_Index = Start_Index + Number_of_Vol_Tets - 1;

    Connectivity = &(Vol_Tet_Connectivity[1][0]);

    Error_Flag = cg_section_write (File_Index, Base_Index, Zone_Index,
                                   "Tets", TETRA_4,
                                   Start_Index, End_Index,
                                   Number_of_Boundary_Items,
                                   Connectivity, &Section_Index);

    if (Error_Flag > 0)
    {
      cg_close(File_Index);
      ug_error_message ("*** ERROR : error writing CGNS grid file ***");
      return (1);
    }
  }
  
  if (Number_of_Vol_Pents_5 != 0)
  {
    for (Index = 1; Index <= Number_of_Vol_Pents_5; ++Index)
    {
      Index_1 = Vol_Pent_5_Connectivity[Index][0];
      Index_2 = Vol_Pent_5_Connectivity[Index][1];
      Index_3 = Vol_Pent_5_Connectivity[Index][2];
      Index_4 = Vol_Pent_5_Connectivity[Index][3];
      Index_5 = Vol_Pent_5_Connectivity[Index][4];

      Vol_Pent_5_Connectivity[Index][0] = Index_2;
      Vol_Pent_5_Connectivity[Index][1] = Index_1;
      Vol_Pent_5_Connectivity[Index][2] = Index_4;
      Vol_Pent_5_Connectivity[Index][3] = Index_5;
      Vol_Pent_5_Connectivity[Index][4] = Index_3;
    }  

    Start_Index = End_Index + 1;

    End_Index = Start_Index + Number_of_Vol_Pents_5 - 1;

    Connectivity = &(Vol_Pent_5_Connectivity[1][0]);

    Error_Flag = cg_section_write (File_Index, Base_Index, Zone_Index,
                                   "Pyramids", PYRA_5,
                                   Start_Index, End_Index,
                                   Number_of_Boundary_Items,
                                   Connectivity, &Section_Index);

    for (Index = 1; Index <= Number_of_Vol_Pents_5; ++Index)
    {
      Index_1 = Vol_Pent_5_Connectivity[Index][0];
      Index_2 = Vol_Pent_5_Connectivity[Index][1];
      Index_3 = Vol_Pent_5_Connectivity[Index][2];
      Index_4 = Vol_Pent_5_Connectivity[Index][3];
      Index_5 = Vol_Pent_5_Connectivity[Index][4];

      Vol_Pent_5_Connectivity[Index][0] = Index_2;
      Vol_Pent_5_Connectivity[Index][1] = Index_1;
      Vol_Pent_5_Connectivity[Index][2] = Index_5;
      Vol_Pent_5_Connectivity[Index][3] = Index_3;
      Vol_Pent_5_Connectivity[Index][4] = Index_4;
    }  

    if (Error_Flag > 0)
    {
      cg_close(File_Index);
      ug_error_message ("*** ERROR : error writing CGNS grid file ***");
      return (1);
    }
  }
  
  if (Number_of_Vol_Pents_6 != 0)
  {
    Start_Index = End_Index + 1;

    End_Index = Start_Index + Number_of_Vol_Pents_6 - 1;

    Connectivity = &(Vol_Pent_6_Connectivity[1][0]);

    Error_Flag = cg_section_write (File_Index, Base_Index, Zone_Index,
                                   "Prisms", PENTA_6,
                                   Start_Index, End_Index,
                                   Number_of_Boundary_Items,
                                   Connectivity, &Section_Index);

    if (Error_Flag > 0)
    {
      cg_close(File_Index);
      ug_error_message ("*** ERROR : error writing CGNS grid file ***");
      return (1);
    }
  }
  
  if (Number_of_Vol_Hexs != 0)
  {
    Start_Index = End_Index + 1;

    End_Index = Start_Index + Number_of_Vol_Hexs - 1;

    Connectivity = &(Vol_Hex_Connectivity[1][0]);

    Error_Flag = cg_section_write (File_Index, Base_Index, Zone_Index,
                                   "Hexs", HEXA_8,
                                   Start_Index, End_Index,
                                   Number_of_Boundary_Items,
                                   Connectivity, &Section_Index);

    if (Error_Flag > 0)
    {
      cg_close(File_Index);
      ug_error_message ("*** ERROR : error writing CGNS grid file ***");
      return (1);
    }
  }
  
  Error_Flag = cg_close(File_Index);
  
  return (0);

}
